/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.mojang.blaze3d.vertex.Tesselator;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystemBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EnumEffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleMathHelper;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackRain
extends AttackSystemBase<RainData> {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, Level w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        float height = ((RainData)this.data).heightAboveTarget;
        PixelmonEntity pixelmon = (PixelmonEntity)w.m_6815_(this.endID);
        height += pixelmon == null ? 2.0f : pixelmon.m_20206_();
        int particlesPerWave = Math.round(1.0f * (float)((RainData)this.data).power / (float)((RainData)this.data).durationTicks);
        for (int tick = 0; tick < ((RainData)this.data).durationTicks; ++tick) {
            for (int i = 0; i < particlesPerWave; ++i) {
                AttackEffect effect = ((RainData)this.data).makeEffect(this).setHideTicks(tick + 1, true);
                double offsetX = 0.0;
                double offsetZ = 0.0;
                Vec3 startOffset = ParticleMathHelper.generatePointInSphere(height / 1.5f, RandomHelper.getRandom());
                double startOffsetX = startOffset.f_82479_;
                double startOffsetZ = startOffset.f_82480_;
                if (((RainData)this.data).maxHorizontalDisplacement > 0.0f) {
                    Vec3 offset = ParticleMathHelper.generatePointInSphere(((RainData)this.data).maxHorizontalDisplacement, RandomHelper.getRandom());
                    offsetX = startOffsetX + offset.f_82479_;
                    offsetZ = startOffsetZ + offset.f_82480_;
                } else {
                    offsetX = startOffsetX;
                    offsetZ = startOffsetZ;
                }
                effect.startX = effect.endX + startOffsetX;
                effect.startY = effect.endY + (double)height;
                effect.startZ = effect.endZ + startOffsetZ;
                effect.endX += offsetX;
                effect.endY = effect.startY - (double)height;
                effect.endZ += offsetZ;
                effect.setHeading();
                mc.f_91061_.m_107344_((Particle)new ParticleArcanery(effect.startX, effect.startY, effect.startZ, 0.0, 0.0, 0.0, effect));
            }
        }
    }

    @Override
    public void onConstruct(AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onEnable(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onTarget(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateLast(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPreRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPostRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    public boolean hasCustomRenderer(AttackEffect effect) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(ParticleArcanery particle, Tesselator tesselator, float partialTicks, AttackEffect effect) {
    }

    public static class RainData
    extends StandardParticleAnimationData {
        public int durationTicks;
        public float maxHorizontalDisplacement = 0.0f;
        public int heightAboveTarget = 2;

        @Override
        public void initFromAttack(ImmutableAttack immutableAttack, int effectivePower, Element effectiveType) {
            if (this.power == -1) {
                this.power = effectivePower / 2;
            }
            super.initFromAttack(immutableAttack, effectivePower, effectiveType);
            if (this.durationTicks == 0) {
                this.durationTicks = (int)Math.ceil(Math.sqrt(effectivePower) * 3.0);
            }
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            super.writeToByteBuffer(buf);
            buf.writeByte(this.durationTicks);
            buf.writeBoolean(this.maxHorizontalDisplacement != 0.0f);
            if (this.maxHorizontalDisplacement != 0.0f) {
                buf.writeFloat(this.maxHorizontalDisplacement);
            }
            buf.writeByte(this.heightAboveTarget);
        }

        @Override
        public RainData readFromByteBuffer(ByteBuf buf) {
            super.readFromByteBuffer(buf);
            this.durationTicks = buf.readByte();
            if (buf.readBoolean()) {
                this.maxHorizontalDisplacement = buf.readFloat();
            }
            this.heightAboveTarget = buf.readByte();
            return this;
        }

        @Override
        public EnumEffectType getEffectEnum() {
            return EnumEffectType.RAIN;
        }

        public RainData setDurationTicks(int durationTicks) {
            this.durationTicks = durationTicks;
            return this;
        }

        public RainData setMaxHorizontalDisplacement(float maxHorizontalDisplacement) {
            this.maxHorizontalDisplacement = maxHorizontalDisplacement;
            return this;
        }

        public RainData setHeightAboveTarget(int heightAboveTarget) {
            this.heightAboveTarget = heightAboveTarget;
            return this;
        }
    }
}

