/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.mojang.blaze3d.vertex.Tesselator;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystemBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EnumEffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleMathHelper;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackExplosion
extends AttackSystemBase<ExplosionData> {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, Level w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        for (int i = 0; i < ((ExplosionData)this.data).power; ++i) {
            mc.f_91061_.m_107344_((Particle)new ParticleArcanery(((ExplosionData)this.data).atTarget ? (double)this.endPos[0] : x, ((ExplosionData)this.data).atTarget ? (double)this.endPos[1] : y, ((ExplosionData)this.data).atTarget ? (double)this.endPos[2] : z, 0.0, 0.0, 0.0, ((ExplosionData)this.data).makeEffect(this).setNoise(30.0)));
        }
    }

    @Override
    public void onConstruct(AttackEffect effect) {
        Vec3 vec = ParticleMathHelper.generatePointInSphere(effect.speed, RandomHelper.getRandom());
        effect.mX = vec.f_82479_;
        effect.mY = vec.f_82480_;
        effect.mZ = vec.f_82481_;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
        particle.m_6569_(2.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onEnable(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
        if (!effect.eol) {
            if (effect.ticker > 5) {
                effect.eol = true;
            }
            particle.setRGBA(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF() * 0.99f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onTarget(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
        particle.setMotion(particle.getMotionX() * 0.95, particle.getMotionY() * 0.95, particle.getMotionZ() * 0.95);
        particle.setRGBA(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF() * 0.8f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateLast(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPreRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPostRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    public boolean hasCustomRenderer(AttackEffect effect) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(ParticleArcanery particle, Tesselator tesselator, float partialTicks, AttackEffect effect) {
    }

    public static class ExplosionData
    extends StandardParticleAnimationData {
        public boolean atTarget = false;

        @Override
        public void initFromAttack(ImmutableAttack attack, int effectivePower, Element effectiveType) {
            if (this.speed == -1.0f) {
                this.speed = 1.2f + RandomHelper.getRandom().nextFloat();
            }
            super.initFromAttack(attack, effectivePower, effectiveType);
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            super.writeToByteBuffer(buf);
            buf.writeBoolean(this.atTarget);
        }

        @Override
        public ExplosionData readFromByteBuffer(ByteBuf buf) {
            super.readFromByteBuffer(buf);
            this.atTarget = buf.readBoolean();
            return this;
        }

        @Override
        public EnumEffectType getEffectEnum() {
            return EnumEffectType.EXPLOSION;
        }
    }
}

