/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.mojang.blaze3d.vertex.Tesselator;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystemBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EnumEffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleMathHelper;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AttackBeam
extends AttackSystemBase<BeamData> {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void execute(Minecraft mc, Level w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        float[] trueStart = this.startPos;
        float trueVariation = ((BeamData)this.data).variation;
        if (((BeamData)this.data).inverted) {
            trueStart = this.endPos;
            this.endPos = this.startPos;
            this.startPos = trueStart;
            PixelmonEntity target = (PixelmonEntity)w.m_6815_(this.endID);
            trueVariation = target == null ? 1.0f : target.m_20206_();
            if (((BeamData)this.data).variation == -1.0f) {
                ((BeamData)this.data).variation = 0.7f;
            }
        }
        for (int segment = 1; segment <= ((BeamData)this.data).segments; ++segment) {
            for (int i = 0; i < ((BeamData)this.data).power / 10 + 5; ++i) {
                Vec3 vec = ParticleMathHelper.generatePointInSphere(trueVariation, RandomHelper.getRandom());
                mc.f_91061_.m_107344_((Particle)new ParticleArcanery((double)trueStart[0] + vec.f_82479_, (double)trueStart[1] + vec.f_82480_, (double)trueStart[2] + vec.f_82481_, 0.0, 0.0, 0.0, ((BeamData)this.data).makeEffect(this).setStartPos((double)trueStart[0] + vec.f_82479_, (double)trueStart[1] + vec.f_82480_, (double)trueStart[2] + vec.f_82481_).setHideTicks(segment, true).setNoise(0.0)));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onConstruct(AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onEnable(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
        double completeFactor = effect.travelledDistance / effect.totalDistance;
        if (completeFactor > 1.0) {
            return;
        }
        particle.setPrevPos(particle.getX(), particle.getY(), particle.getZ());
        float newX = (float)(particle.getX() + ((double)this.startPos[0] + (double)(this.endPos[0] - this.startPos[0]) * completeFactor - particle.getX()) * (double)(1.0f - ((BeamData)this.data).variation));
        float newY = (float)(particle.getY() + ((double)this.startPos[1] + (double)(this.endPos[1] - this.startPos[1]) * completeFactor - particle.getY()) * (double)(1.0f - ((BeamData)this.data).variation));
        float newZ = (float)(particle.getZ() + ((double)this.startPos[2] + (double)(this.endPos[2] - this.startPos[2]) * completeFactor - particle.getZ()) * (double)(1.0f - ((BeamData)this.data).variation));
        particle.m_107264_(newX, newY, newZ);
        effect.travelledDistance += Math.abs(Math.sqrt(Math.pow(newX - this.endPos[0], 2.0) + Math.pow(newY - this.endPos[1], 2.0) + Math.pow(newZ - this.endPos[2], 2.0)) - Math.sqrt(Math.pow(particle.getPrevX() - (double)this.endPos[0], 2.0) + Math.pow(particle.getPrevY() - (double)this.endPos[1], 2.0) + Math.pow(particle.getPrevZ() - (double)this.endPos[2], 2.0)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onTarget(ParticleArcanery particle, AttackEffect effect) {
        if (!((BeamData)this.data).inverted) {
            particle.setMotion(RandomHelper.getLegacyRandom().nextDouble() - 0.5, RandomHelper.getLegacyRandom().nextDouble() - 0.5, RandomHelper.getLegacyRandom().nextDouble() - 0.5);
            particle.setMotion(particle.getMotionX() * 0.05, particle.getMotionY() * 0.05, particle.getMotionZ() * 0.05);
        } else {
            particle.m_107274_();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
        particle.setRGBA(particle.getRedColorF(), particle.getGreenColorF(), particle.getBlueColorF(), particle.getAlphaF() * 0.95f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateLast(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPreRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPostRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCustomRenderer(AttackEffect effect) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(ParticleArcanery particle, Tesselator tesselator, float partialTicks, AttackEffect effect) {
    }

    public static class BeamData
    extends StandardParticleAnimationData {
        public int segments = 15;
        public float variation = -1.0f;
        public boolean inverted = false;

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void initFromAttack(ImmutableAttack attack, int effectivePower, Element effectiveType) {
            if (this.speed == -1.0f) {
                this.speed = 0.75f + (RandomHelper.getRandom().nextFloat() - 0.5f) / 5.0f;
            }
            if (this.variation == -1.0f && !this.inverted) {
                this.variation = 0.25f;
            }
            super.initFromAttack(attack, effectivePower, effectiveType);
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            buf.writeByte(this.segments);
            buf.writeBoolean(this.inverted);
            buf.writeBoolean(this.variation != -1.0f);
            if (this.variation != -1.0f) {
                buf.writeFloat(this.variation);
            }
            super.writeToByteBuffer(buf);
        }

        @Override
        public BeamData readFromByteBuffer(ByteBuf buf) {
            this.segments = buf.readUnsignedByte();
            this.inverted = buf.readBoolean();
            if (buf.readBoolean()) {
                this.variation = buf.readFloat();
            }
            return (BeamData)super.readFromByteBuffer(buf);
        }

        @Override
        public EnumEffectType getEffectEnum() {
            return EnumEffectType.BEAM;
        }

        public BeamData setSegments(int segments) {
            this.segments = segments;
            return this;
        }

        public BeamData setVariation(float variation) {
            this.variation = variation;
            return this;
        }

        public BeamData setInverted(boolean inverted) {
            this.inverted = inverted;
            return this;
        }
    }
}

