/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.attacks.animations.AttackAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystemBase;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import io.netty.buffer.ByteBuf;

public abstract class StandardParticleAnimationData
extends AttackAnimationData {
    public int power = -1;
    public float speed = -1.0f;
    public int[] rgb = null;
    public AttackEffect.EnumParticleTexture texture = null;
    public int lifetimeTicks = -1;
    public float scale = -1.0f;

    @Override
    public void initFromAttack(ImmutableAttack attack, int effectivePower, Element effectiveType) {
        if (this.power == -1 || this.power == 0) {
            int n = this.power = effectivePower == 0 ? 40 : effectivePower;
        }
        if (this.speed == -1.0f) {
            this.speed = 1.0f;
        }
        if (this.rgb == null) {
            this.rgb = new int[]{(effectiveType.getColor() & 0xFF0000) >> 16, (effectiveType.getColor() & 0xFF00) >> 8, effectiveType.getColor() & 0xFF};
        }
        if (this.texture == null) {
            this.texture = effectiveType == Element.GRASS ? AttackEffect.EnumParticleTexture.LEAF : (effectiveType == Element.FIRE ? AttackEffect.EnumParticleTexture.FLAME : (effectiveType == Element.WATER ? AttackEffect.EnumParticleTexture.WATER : AttackEffect.EnumParticleTexture.NORMAL));
        }
        if (this.lifetimeTicks == -1) {
            this.lifetimeTicks = 0;
        }
        if (this.scale == -1.0f) {
            this.scale = 0.15f + 0.03f * (float)(this.power / 5);
        }
    }

    @Override
    public void writeToByteBuffer(ByteBuf buf) {
        buf.writeBoolean(this.power != -1);
        if (this.power != -1) {
            buf.writeShort(this.power);
        }
        buf.writeBoolean(this.speed != -1.0f);
        if (this.speed != -1.0f) {
            buf.writeFloat(this.speed);
        }
        buf.writeBoolean(this.rgb != null);
        if (this.rgb != null) {
            buf.writeByte(this.rgb[0]);
            buf.writeByte(this.rgb[1]);
            buf.writeByte(this.rgb[2]);
        }
        buf.writeBoolean(this.texture != null);
        if (this.texture != null) {
            buf.writeByte(this.texture.ordinal());
        }
        buf.writeBoolean(this.lifetimeTicks != -1);
        if (this.lifetimeTicks != -1) {
            buf.writeByte(this.lifetimeTicks);
        }
        buf.writeBoolean(this.scale != -1.0f);
        if (this.scale != -1.0f) {
            buf.writeFloat(this.scale);
        }
    }

    @Override
    public StandardParticleAnimationData readFromByteBuffer(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.power = buf.readShort();
        }
        if (buf.readBoolean()) {
            this.speed = buf.readFloat();
        }
        if (buf.readBoolean()) {
            this.rgb = new int[]{buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()};
        }
        if (buf.readBoolean()) {
            this.texture = AttackEffect.EnumParticleTexture.values()[buf.readByte()];
        }
        if (buf.readBoolean()) {
            this.lifetimeTicks = buf.readUnsignedByte();
        }
        if (buf.readBoolean()) {
            this.scale = buf.readFloat();
        }
        return this;
    }

    public AttackEffect makeEffect(AttackSystemBase<? extends StandardParticleAnimationData> system) {
        return new AttackEffect(system, system.startID, system.startPos, system.endID, system.endPos, (StandardParticleAnimationData)system.data);
    }

    public StandardParticleAnimationData setPower(int power) {
        this.power = power;
        return this;
    }

    public StandardParticleAnimationData setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public StandardParticleAnimationData setRGB(int r, int g, int b) {
        this.rgb = new int[]{r, g, b};
        return this;
    }

    public StandardParticleAnimationData setTexture(AttackEffect.EnumParticleTexture texture) {
        this.texture = texture;
        return this;
    }

    public StandardParticleAnimationData setLifetimeTicks(int lifetimeTicks) {
        this.lifetimeTicks = lifetimeTicks;
        return this;
    }

    public StandardParticleAnimationData setScale(float scale) {
        this.scale = scale;
        return this;
    }
}

