/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.value;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.api.rules.PropertyValue;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class ClausesValue
implements PropertyValue<Set<BattleClause>> {
    private Set<BattleClause> value;

    public ClausesValue(Set<BattleClause> value) {
        this.value = value;
    }

    @Override
    public Set<BattleClause> get() {
        return this.value;
    }

    @Override
    public void update(Set<BattleClause> integer) {
        this.value = integer;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.value.size());
        Iterator<BattleClause> clauses = this.value.iterator();
        for (int i = 0; i < this.value.size(); ++i) {
            buffer.m_130070_(clauses.next().getID());
        }
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<String> badClauses = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            String clause = buffer.m_130277_();
            if (!BattleClauseRegistry.hasClause(clause)) {
                badClauses.add(clause);
                continue;
            }
            this.value.add(BattleClauseRegistry.getClause(clause));
        }
        if (badClauses.size() > 0) {
            String error = "Unable to decode some BattleClauses properly - " + String.join((CharSequence)", ", badClauses.toArray(new String[0]));
            Pixelmon.LOGGER.error(error);
        }
    }

    @Override
    public void write(String key, CompoundTag compound) {
        ListTag clauses = new ListTag();
        this.value.forEach(clause -> clauses.add((Object)StringTag.m_129297_((String)clause.getID())));
        compound.m_128365_(key, (Tag)clauses);
    }

    @Override
    public void read(String key, CompoundTag compound) {
        ListTag clauses = compound.m_128437_(key, (int)StringTag.m_129297_((String)"").m_7060_());
        ArrayList<String> badClauses = new ArrayList<String>();
        for (Tag nbt : clauses) {
            if (!BattleClauseRegistry.hasClause(nbt.m_7916_())) {
                badClauses.add(nbt.m_7916_());
                continue;
            }
            this.value.add(BattleClauseRegistry.getClause(nbt.m_7916_()));
        }
        if (badClauses.size() > 0) {
            String error = "Unable to decode some BattleClauses properly - " + String.join((CharSequence)", ", badClauses.toArray(new String[0]));
            Pixelmon.LOGGER.error(error);
        }
    }
}

