/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.teamselection;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelection;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public final class TeamSelectionRegistry {
    private static int idCounter;
    private static final Map<Integer, TeamSelection> teamSelectMap;

    private TeamSelectionRegistry() {
    }

    public static void addTeamSelection(BattleRules rules, boolean showRules, PartyStorage ... storages) {
        int newID = idCounter++;
        TeamSelection selection = new TeamSelection(newID, rules, showRules, true, true, storages);
        teamSelectMap.put(newID, selection);
        selection.initializeClient();
    }

    public static void addTeamSelection(TeamSelection selection) {
        teamSelectMap.put(selection.id, selection);
        selection.initializeClient();
    }

    public static void removeSelection(ServerPlayer player) {
        for (TeamSelection selection : teamSelectMap.values()) {
            if (!selection.hasPlayer(player)) continue;
            teamSelectMap.remove(selection.id);
            return;
        }
    }

    static void removeSelection(int id) {
        teamSelectMap.remove(id);
    }

    public static TeamSelection getTeamSelection(int id) {
        return teamSelectMap.get(id);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        teamSelectMap = new HashMap<Integer, TeamSelection>();
    }

    public static class Builder {
        protected BattleRules battleRules = new BattleRules();
        protected List<PartyStorage> members = Lists.newArrayList();
        protected boolean showRules = false;
        protected boolean showOpponentTeam = true;
        protected boolean closeable = true;
        protected Consumer<TeamSelection> cancelConsumer = null;
        protected Consumer<BattleController> battleStartConsumer = null;

        protected Builder() {
        }

        public Builder battleRules(BattleRules battleRules) {
            this.battleRules = battleRules;
            return this;
        }

        public Builder members(Entity ... entities) {
            for (Entity entity : entities) {
                if (entity instanceof NPCTrainer) {
                    this.members(((NPCTrainer)entity).getPokemonStorage());
                    continue;
                }
                this.members(StorageProxy.getPartyNow(entity.m_20148_()));
            }
            return this;
        }

        public Builder members(PartyStorage ... storage) {
            this.members.addAll(Lists.newArrayList((Object[])storage));
            return this;
        }

        public Builder showRules() {
            return this.showRules(true);
        }

        public Builder showRules(boolean showRules) {
            this.showRules = showRules;
            return this;
        }

        public Builder cancelConsumer(Consumer<TeamSelection> cancelConsumer) {
            this.cancelConsumer = cancelConsumer;
            return this;
        }

        public Builder battleStartConsumer(Consumer<BattleController> battleStartConsumer) {
            this.battleStartConsumer = battleStartConsumer;
            return this;
        }

        public Builder showOpponentTeam() {
            this.showOpponentTeam = true;
            return this;
        }

        public Builder hideOpponentTeam() {
            this.showOpponentTeam = false;
            return this;
        }

        public Builder closeable() {
            return this.closeable(true);
        }

        public Builder notCloseable() {
            return this.closeable(false);
        }

        public Builder closeable(boolean closeable) {
            this.closeable = closeable;
            return this;
        }

        public void start() {
            int newID = idCounter++;
            TeamSelectionRegistry.addTeamSelection(new TeamSelection(newID, this.battleRules, this.showRules, this.showOpponentTeam, this.closeable, this.cancelConsumer, this.battleStartConsumer, this.members.toArray(new PartyStorage[0])));
        }
    }
}

