/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.clauses.type;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Download;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Moody;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SpeedBoost;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.type.MoveClause;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;

public class SpeedPassClause
extends BattleClause {
    private MoveClause batonPassClause = new MoveClause("", true, AttackRegistry.BATON_PASS);

    public SpeedPassClause() {
        super("speedpass");
    }

    @Override
    public boolean validateSingle(Pokemon pokemon) {
        if (this.batonPassClause.validateSingle(pokemon)) {
            return true;
        }
        boolean hasSpeedBoost = false;
        boolean hasOtherBoost = false;
        Ability ability = pokemon.getAbility();
        if (ability.isAbility((Class<? extends Ability>)Moody.class)) {
            return false;
        }
        if (ability.isAbility((Class<? extends Ability>)SpeedBoost.class)) {
            hasSpeedBoost = true;
        } else if (ability.isAbility((Class<? extends Ability>)Download.class)) {
            hasOtherBoost = true;
        }
        for (Attack attack : pokemon.getMoveset().attacks) {
            if (attack == null) continue;
            if (attack.isAttack(AttackRegistry.GEOMANCY)) {
                return false;
            }
            for (EffectBase effect : attack.getMove().effects) {
                if (!(effect.getChance() >= 100.0f) || !(effect instanceof StatsEffect)) continue;
                StatsEffect statsEffect = (StatsEffect)effect;
                BattleStatsType stat = statsEffect.getStatsType();
                if (stat == BattleStatsType.SPEED) {
                    hasSpeedBoost = true;
                    continue;
                }
                hasOtherBoost = true;
            }
            if (!attack.isAttack(AttackRegistry.BELLY_DRUM, AttackRegistry.CURSE, AttackRegistry.GROWTH, AttackRegistry.MAGNETIC_FLUX, AttackRegistry.MINIMIZE, AttackRegistry.ROTOTILLER, AttackRegistry.SKULL_BASH, AttackRegistry.STOCKPILE)) continue;
            hasOtherBoost = true;
        }
        return !hasSpeedBoost || !hasOtherBoost;
    }
}

