/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.clauses.type;

import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SkyBattleClause
extends BattleClause {
    private static final Set<RegistryValue<Species>> ALLOWED_POKEMON = new HashSet<RegistryValue<Species>>();
    private static final Set<ImmutableAttack> PROHIBITED_MOVES = new HashSet<ImmutableAttack>();

    public SkyBattleClause() {
        super("sky");
    }

    @Override
    public boolean validateSingle(Pokemon pokemon) {
        return ALLOWED_POKEMON.contains(pokemon.getSpecies().getRegistryValue());
    }

    public static boolean isMoveAllowed(Attack move) {
        return !PROHIBITED_MOVES.contains(move.getMove());
    }

    static {
        ALLOWED_POKEMON.addAll(Arrays.asList(PixelmonSpecies.CHARIZARD, PixelmonSpecies.BUTTERFREE, PixelmonSpecies.PIDGEOTTO, PixelmonSpecies.PIDGEOT, PixelmonSpecies.FEAROW, PixelmonSpecies.ZUBAT, PixelmonSpecies.GOLBAT, PixelmonSpecies.GASTLY, PixelmonSpecies.HAUNTER, PixelmonSpecies.KOFFING, PixelmonSpecies.WEEZING, PixelmonSpecies.SCYTHER, PixelmonSpecies.GYARADOS, PixelmonSpecies.AERODACTYL, PixelmonSpecies.ARTICUNO, PixelmonSpecies.ZAPDOS, PixelmonSpecies.MOLTRES, PixelmonSpecies.DRAGONITE, PixelmonSpecies.NOCTOWL, PixelmonSpecies.LEDYBA, PixelmonSpecies.LEDIAN, PixelmonSpecies.CROBAT, PixelmonSpecies.TOGETIC, PixelmonSpecies.XATU, PixelmonSpecies.HOPPIP, PixelmonSpecies.SKIPLOOM, PixelmonSpecies.JUMPLUFF, PixelmonSpecies.YANMA, PixelmonSpecies.MISDREAVUS, PixelmonSpecies.UNOWN, PixelmonSpecies.GLIGAR, PixelmonSpecies.MANTINE, PixelmonSpecies.SKARMORY, PixelmonSpecies.LUGIA, PixelmonSpecies.HOOH, PixelmonSpecies.BEAUTIFLY, PixelmonSpecies.SWELLOW, PixelmonSpecies.WINGULL, PixelmonSpecies.PELIPPER, PixelmonSpecies.MASQUERAIN, PixelmonSpecies.NINJASK, PixelmonSpecies.VIBRAVA, PixelmonSpecies.FLYGON, PixelmonSpecies.SWABLU, PixelmonSpecies.ALTARIA, PixelmonSpecies.LUNATONE, PixelmonSpecies.SOLROCK, PixelmonSpecies.BALTOY, PixelmonSpecies.CLAYDOL, PixelmonSpecies.DUSKULL, PixelmonSpecies.TROPIUS, PixelmonSpecies.CHIMECHO, PixelmonSpecies.SALAMENCE, PixelmonSpecies.LATIAS, PixelmonSpecies.LATIOS, PixelmonSpecies.RAYQUAZA, PixelmonSpecies.STARAVIA, PixelmonSpecies.STARAPTOR, PixelmonSpecies.MOTHIM, PixelmonSpecies.COMBEE, PixelmonSpecies.VESPIQUEN, PixelmonSpecies.DRIFLOON, PixelmonSpecies.DRIFBLIM, PixelmonSpecies.MISMAGIUS, PixelmonSpecies.HONCHKROW, PixelmonSpecies.CHINGLING, PixelmonSpecies.MANTYKE, PixelmonSpecies.TOGEKISS, PixelmonSpecies.YANMEGA, PixelmonSpecies.GLISCOR, PixelmonSpecies.UXIE, PixelmonSpecies.MESPRIT, PixelmonSpecies.AZELF, PixelmonSpecies.SIGILYPH, PixelmonSpecies.ARCHEOPS, PixelmonSpecies.EMOLGA, PixelmonSpecies.CRYOGONAL, PixelmonSpecies.BRAVIARY));
        for (RegistryValue immutableAttack : Arrays.asList(AttackRegistry.BODY_SLAM, AttackRegistry.BULLDOZE, AttackRegistry.DIG, AttackRegistry.DIVE, AttackRegistry.EARTH_POWER, AttackRegistry.EARTHQUAKE, AttackRegistry.ELECTRIC_TERRAIN, AttackRegistry.FISSURE, AttackRegistry.FIRE_PLEDGE, AttackRegistry.FLYING_PRESS, AttackRegistry.FRENZY_PLANT, AttackRegistry.GEOMANCY, AttackRegistry.GRASS_KNOT, AttackRegistry.GRASS_PLEDGE, AttackRegistry.GRASSY_TERRAIN, AttackRegistry.GRAVITY, AttackRegistry.HEAT_CRASH, AttackRegistry.HEAVY_SLAM, AttackRegistry.INGRAIN, AttackRegistry.LANDS_WRATH, AttackRegistry.MAGNITUDE, AttackRegistry.MAT_BLOCK, AttackRegistry.MISTY_TERRAIN, AttackRegistry.MUD_SPORT, AttackRegistry.MUDDY_WATER, AttackRegistry.ROTOTILLER, AttackRegistry.SEISMIC_TOSS, AttackRegistry.SLAM, AttackRegistry.SMACK_DOWN, AttackRegistry.SPIKES, AttackRegistry.STOMP, AttackRegistry.SUBSTITUTE, AttackRegistry.SURF, AttackRegistry.TOXIC_SPIKES, AttackRegistry.THOUSAND_ARROWS, AttackRegistry.THOUSAND_WAVES, AttackRegistry.WATER_PLEDGE, AttackRegistry.WATER_SPORT)) {
            immutableAttack.ifPresent(PROHIBITED_MOVES::add);
        }
    }
}

