/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.clauses;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.IEncodeable;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class BattleClause
implements Comparable<BattleClause>,
IEncodeable {
    private String id;
    private String description = "";

    public BattleClause(String id) {
        this.id = id;
    }

    public BattleClause setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getID() {
        return this.id;
    }

    public String getDescription() {
        if (!this.description.isEmpty()) {
            return this.description;
        }
        return Component.m_237115_((String)("gui.battlerules.description." + this.id)).getString();
    }

    public String getLocalizedName() {
        return BattleClause.getLocalizedName(this.id);
    }

    public static String getLocalizedName(String clauseID) {
        String langKey = "gui.battlerules." + clauseID;
        return Component.m_237115_((String)langKey).getString();
    }

    public boolean validateSingle(Pokemon pokemon) {
        return true;
    }

    public boolean validateTeam(List<Pokemon> team) {
        for (Pokemon pokemon : team) {
            if (this.validateSingle(pokemon)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void encodeInto(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.id);
        buffer.m_130070_(this.description);
    }

    @Override
    public void decodeInto(FriendlyByteBuf buffer) {
        this.id = buffer.m_130277_();
        this.description = buffer.m_130277_();
    }

    @Override
    public int compareTo(BattleClause o) {
        return this.id.compareTo(o.getID());
    }

    public boolean equals(Object other) {
        if (other instanceof BattleClause) {
            return ((BattleClause)other).getID().equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getLocalizedName();
    }
}

