/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.IEncodeable;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.PropertyValue;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleTierRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.tiers.Tier;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class BattleRules
implements IEncodeable,
Cloneable {
    public static final int MAX_NUM_POKEMON = 6;
    private Map<BattleProperty<?>, PropertyValue<?>> properties = Maps.newHashMap();

    public BattleRules() {
        for (BattleProperty<?> allProperty : BattleRuleRegistry.getAllProperties()) {
            allProperty.getDefault().ifPresent(propertyValue -> this.properties.put(allProperty, (PropertyValue<?>)propertyValue));
        }
    }

    public BattleRules(BattleType battleType) {
        this();
        this.set(BattleRuleRegistry.BATTLE_TYPE, (Object)battleType);
    }

    public BattleRules(String text) {
        this.importText(text);
    }

    public <T> BattleRules set(BattleProperty<T> property, Object o) {
        property.parse(o).ifPresent(tPropertyValue -> this.properties.put(property, (PropertyValue<?>)tPropertyValue));
        return this;
    }

    public <T> Optional<T> get(BattleProperty<T> property) {
        PropertyValue<?> propertyValue = this.properties.get(property);
        if (propertyValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(propertyValue.get());
    }

    public <T> T getOrDefault(BattleProperty<T> property) {
        PropertyValue<?> propertyValue = this.properties.get(property);
        if (propertyValue == null) {
            if (!property.getDefault().isPresent()) {
                return property.getInstance().get();
            }
            return property.getDefault().get().get();
        }
        return (T)propertyValue.get();
    }

    public BattleRules clone() {
        BattleRules newRules = new BattleRules();
        for (Map.Entry<BattleProperty<?>, PropertyValue<?>> entry : this.properties.entrySet()) {
            PropertyValue<?> instance = entry.getKey().getInstance();
            instance.set(entry.getValue().get());
            newRules.set(entry.getKey(), instance);
        }
        return newRules;
    }

    public String exportText() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<BattleProperty<?>, PropertyValue<?>> entry : this.properties.entrySet()) {
            builder.append(entry.getKey().getId()).append(": ").append(entry.getValue().get().toString());
        }
        return builder.toString();
    }

    public String importText(String text) {
        String[] importTextSplit;
        for (String line : importTextSplit = text.split("\n")) {
            String[] split = line.split(": ");
            BattleProperty<?> property = BattleRuleRegistry.getProperty(split[0]);
            if (property == null) continue;
            PropertyValue<?> instance = property.getInstance();
            instance.set(property.parse(split[1]).orElse(null));
            this.properties.put(property, instance);
        }
        return null;
    }

    @Override
    public void encodeInto(FriendlyByteBuf buf) {
        buf.writeInt(this.properties.size());
        for (Map.Entry<BattleProperty<?>, PropertyValue<?>> entry : this.properties.entrySet()) {
            if (!entry.getKey().requiredByClient()) {
                buf.m_130070_("null");
                continue;
            }
            buf.m_130070_(entry.getKey().getId());
            entry.getValue().encode(buf);
        }
    }

    @Override
    public void decodeInto(FriendlyByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String key = buf.m_130277_();
            if (key.equalsIgnoreCase("null")) continue;
            BattleProperty<?> property = BattleRuleRegistry.getProperty(key);
            PropertyValue<?> value = null;
            value = property.getDefault().isPresent() ? property.getDefault().get() : property.getInstance();
            value.decode(buf);
            this.properties.put(property, value);
        }
    }

    public void writeToNBT(CompoundTag nbt) {
        for (Map.Entry<BattleProperty<?>, PropertyValue<?>> entry : this.properties.entrySet()) {
            entry.getValue().write(entry.getKey().getId(), nbt);
        }
    }

    public void readFromNBT(CompoundTag nbt) {
        for (String allKey : nbt.m_128431_()) {
            BattleProperty<?> property = BattleRuleRegistry.getProperty(allKey);
            if (property == null) continue;
            PropertyValue<?> instance = property.getInstance();
            instance.read(allKey, nbt);
            this.properties.put(property, instance);
        }
    }

    public List<BattleClause> getClauseList() {
        ArrayList clauseList = Lists.newArrayList((Iterable)this.get(BattleRuleRegistry.CLAUSES).orElse(Collections.emptySet()));
        Collections.sort(clauseList);
        return clauseList;
    }

    public List<String> getClauseIDs() {
        ArrayList<String> clauseIDs = new ArrayList<String>();
        for (BattleClause clause : this.getClauseList()) {
            clauseIDs.add(clause.getID());
        }
        Collections.sort(clauseIDs);
        return clauseIDs;
    }

    public boolean hasClause(BattleClause clause) {
        return this.getOrDefault(BattleRuleRegistry.CLAUSES).contains(clause);
    }

    public boolean hasClause(String id) {
        return this.hasClause(BattleClauseRegistry.getClause(id));
    }

    public void setNewClauses(List<BattleClause> newClauses) {
        PropertyValue<Set<BattleClause>> instance = BattleRuleRegistry.CLAUSES.getInstance();
        instance.set(Sets.newHashSet(newClauses));
        this.set(BattleRuleRegistry.CLAUSES, instance);
    }

    public boolean isDefault() {
        boolean defaultClauses = this.get(BattleRuleRegistry.CLAUSES).orElse(Collections.emptySet()).isEmpty();
        if (this.get(BattleRuleRegistry.CLAUSES).orElse(Collections.emptySet()).size() == 1) {
            defaultClauses = this.hasClause(BattleClauseRegistry.FORFEIT_CLAUSE);
        }
        return defaultClauses && this.get(BattleRuleRegistry.GEN_MODE).orElse(EnumOldGenMode.World) == EnumOldGenMode.World && this.get(BattleRuleRegistry.BATTLE_TYPE).orElse(BattleType.SINGLE) == BattleType.SINGLE && this.get(BattleRuleRegistry.LEVEL_CAP).orElse(PixelmonServerConfig.maxLevel) == PixelmonServerConfig.maxLevel && this.get(BattleRuleRegistry.RAISE_TO_CAP).orElse(false) == false && this.get(BattleRuleRegistry.NUM_POKEMON).orElse(6) == 6 && this.get(BattleRuleRegistry.TURN_TIME).orElse(0) == 0 && this.get(BattleRuleRegistry.TEAM_SELECT).orElse(0) == 0 && this.get(BattleRuleRegistry.TEAM_PREVIEW).orElse(false) == false;
    }

    public String validateSingle(Pokemon pokemon) {
        for (BattleClause clause : this.getClauseList()) {
            if (clause.validateSingle(pokemon)) continue;
            return clause.getID();
        }
        return null;
    }

    public String validateTeam(List<Pokemon> team) {
        for (BattleClause clause : this.getClauseList()) {
            if (clause.validateTeam(team)) continue;
            return clause.getID();
        }
        return null;
    }

    private Tier getDefaultTier() {
        return BattleTierRegistry.UNRESTRICTED;
    }
}

