/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.api.rules.clauses.tiers.Tier;
import com.pixelmonmod.pixelmon.battles.api.rules.property.BattleTypeProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.property.ClausesProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.property.FullHealProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.property.LevelCapProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.property.NoCritsProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.property.NumPokemonProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.property.OldGenModeProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.property.RaiseToCapProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.property.TeamPreviewProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.property.TeamSelectProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.property.TierProperty;
import com.pixelmonmod.pixelmon.battles.api.rules.property.TurnTimeProperty;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BattleRuleRegistry {
    private static final Map<String, BattleProperty<?>> REGISTERED_PROPERTIES = Maps.newConcurrentMap();
    public static final BattleProperty<Boolean> RAISE_TO_CAP = BattleRuleRegistry.register(new RaiseToCapProperty());
    public static final BattleProperty<Boolean> FULL_HEAL = BattleRuleRegistry.register(new FullHealProperty());
    public static final BattleProperty<Boolean> TEAM_PREVIEW = BattleRuleRegistry.register(new TeamPreviewProperty());
    public static final BattleProperty<Integer> LEVEL_CAP = BattleRuleRegistry.register(new LevelCapProperty());
    public static final BattleProperty<Integer> NUM_POKEMON = BattleRuleRegistry.register(new NumPokemonProperty());
    public static final BattleProperty<Integer> TEAM_SELECT = BattleRuleRegistry.register(new TeamSelectProperty());
    public static final BattleProperty<Integer> TURN_TIME = BattleRuleRegistry.register(new TurnTimeProperty());
    public static final BattleProperty<Tier> TIER = BattleRuleRegistry.register(new TierProperty());
    public static final BattleProperty<Set<BattleClause>> CLAUSES = BattleRuleRegistry.register(new ClausesProperty());
    public static final BattleProperty<BattleType> BATTLE_TYPE = BattleRuleRegistry.register(new BattleTypeProperty());
    public static final BattleProperty<EnumOldGenMode> GEN_MODE = BattleRuleRegistry.register(new OldGenModeProperty());
    public static final BattleProperty<Boolean> NO_CRITS = BattleRuleRegistry.register(new NoCritsProperty());

    public static <T> BattleProperty<T> register(BattleProperty<T> property) {
        REGISTERED_PROPERTIES.put(property.getId().toLowerCase(Locale.ROOT), property);
        return property;
    }

    public static BattleProperty<?> getProperty(String id) {
        return REGISTERED_PROPERTIES.get(id.toLowerCase(Locale.ROOT));
    }

    public static List<BattleProperty<?>> getAllProperties() {
        return Lists.newArrayList(REGISTERED_PROPERTIES.values());
    }
}

