/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api;

import com.google.common.collect.Maps;
import com.pixelmonmod.api.scheduler.DelayedScheduler;
import com.pixelmonmod.pixelmon.api.events.ExperienceGainEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleStartedEvent;
import com.pixelmonmod.pixelmon.api.events.battles.SpectateEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelectionRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BattleBuilder {
    protected BattleParticipant[] teamOne;
    protected BattleParticipant[] teamTwo;
    protected BattleRules rules;
    protected Map<Class<? extends BattleEvent>, BiConsumer<? extends BattleEvent, BattleController>> eventHandlers = Maps.newHashMap();
    protected Consumer<BattleController> setupHandler = battleController -> {};
    protected boolean disableExp = false;
    protected boolean allowSpectators = true;
    protected boolean teamSelection = false;
    protected TeamSelectionRegistry.Builder selectionBuilder = null;
    protected long startDelayMillis = -1L;
    protected boolean startSync = false;
    protected boolean removeFromTempParties = true;
    protected boolean freezeBattle = false;
    protected boolean forceChance = false;
    protected boolean noCrits = false;

    private BattleBuilder() {
    }

    public BattleBuilder teamOne(BattleParticipant ... teamOne) {
        this.teamOne = teamOne;
        return this;
    }

    public BattleBuilder teamTwo(BattleParticipant ... teamTwo) {
        this.teamTwo = teamTwo;
        return this;
    }

    public BattleBuilder rules(BattleRules rules) {
        this.rules = rules;
        return this;
    }

    public BattleBuilder endHandler(BiConsumer<BattleEndEvent, BattleController> endConsumer) {
        return this.eventHandler(BattleEndEvent.class, endConsumer);
    }

    public BattleBuilder startHandler(BiConsumer<BattleStartedEvent.Pre, BattleController> startConsumer) {
        return this.eventHandler(BattleStartedEvent.Pre.class, startConsumer);
    }

    public BattleBuilder setupHandler(Consumer<BattleController> setupHandler) {
        this.setupHandler = setupHandler;
        return this;
    }

    public <E extends BattleEvent> BattleBuilder eventHandler(Class<E> eventClass, BiConsumer<E, BattleController> eventHandler) {
        this.eventHandlers.put(eventClass, eventHandler);
        return this;
    }

    public BattleBuilder disableExp() {
        this.disableExp = true;
        return this;
    }

    public BattleBuilder expEnabled() {
        this.disableExp = false;
        return this;
    }

    public BattleBuilder allowSpectators() {
        return this.allowSpectators(true);
    }

    public BattleBuilder disallowSpectators() {
        return this.allowSpectators(false);
    }

    public BattleBuilder allowSpectators(boolean allowSpectators) {
        this.allowSpectators = allowSpectators;
        return this;
    }

    public BattleBuilder teamSelection() {
        return this.teamSelection(true);
    }

    public BattleBuilder noSelection() {
        return this.teamSelection(false);
    }

    public BattleBuilder teamSelection(boolean teamSelection) {
        this.teamSelection = teamSelection;
        if (this.teamSelection) {
            this.selectionBuilder = TeamSelectionRegistry.builder();
        }
        return this;
    }

    public BattleBuilder teamSelectionBuilder(TeamSelectionRegistry.Builder selectionBuilder) {
        this.selectionBuilder = selectionBuilder;
        return this;
    }

    public BattleBuilder startDelay(long startDelay, TimeUnit timeUnit) {
        this.startDelayMillis = timeUnit.toMillis(startDelay);
        return this;
    }

    public BattleBuilder startSync() {
        this.startSync = true;
        return this;
    }

    public BattleBuilder startAsync() {
        this.startSync = false;
        return this;
    }

    public BattleBuilder removeFromTempParty() {
        this.removeFromTempParties = true;
        return this;
    }

    public BattleBuilder ignoreTempParties() {
        this.removeFromTempParties = false;
        return this;
    }

    public BattleBuilder frozen() {
        this.freezeBattle = true;
        return this;
    }

    public BattleBuilder notFrozen() {
        this.freezeBattle = false;
        return this;
    }

    public BattleBuilder forceChance() {
        this.forceChance = true;
        return this;
    }

    public BattleBuilder noCrits() {
        this.noCrits = true;
        return this;
    }

    public CompletableFuture<BattleController> start() {
        if (this.startDelayMillis != -1L) {
            return DelayedScheduler.schedule(() -> {}, this.startDelayMillis, TimeUnit.MILLISECONDS).thenCompose(unused -> {
                if (!this.startSync) {
                    return this.startBattle();
                }
                CompletableFuture controllerFuture = new CompletableFuture();
                ServerLifecycleHooks.getCurrentServer().execute(() -> ((CompletableFuture)this.startBattle().thenApply(controllerFuture::complete)).exceptionally(controllerFuture::completeExceptionally));
                return controllerFuture;
            });
        }
        return this.startBattle();
    }

    protected CompletableFuture<BattleController> startBattle() {
        if (this.teamSelection) {
            CompletableFuture<BattleController> controllerFuture = new CompletableFuture<BattleController>();
            this.selectionBuilder.members(this.teamOne[0].getStorage(), this.teamTwo[0].getStorage()).battleStartConsumer(battleController -> {
                this.setupController((BattleController)battleController);
                controllerFuture.complete((BattleController)battleController);
            }).start();
            return controllerFuture;
        }
        BattleController controller = BattleRegistry.startBattle(this.teamOne, this.teamTwo, this.rules);
        this.setupController(controller);
        return CompletableFuture.completedFuture(controller);
    }

    protected void setupController(BattleController controller) {
        if (this.disableExp) {
            controller.addPersistentTaskAtEvent(ExperienceGainEvent.class, (experienceGainEvent, battleController) -> experienceGainEvent.setCanceled(true));
        }
        if (!this.allowSpectators) {
            controller.addPersistentTaskAtEvent(SpectateEvent.StartSpectate.class, (spectateStartEvent, battleController) -> spectateStartEvent.setCanceled(true));
        }
        if (this.removeFromTempParties) {
            controller.addPersistentTaskAtEvent(BattleEndEvent.class, this::handleClearingTemporaryMode);
        }
        for (Map.Entry<Class<? extends BattleEvent>, BiConsumer<? extends BattleEvent, BattleController>> entry : this.eventHandlers.entrySet()) {
            this.addTask(controller, entry.getKey(), entry.getValue());
        }
        if (this.freezeBattle) {
            controller.freeze();
            controller.modifyStats();
        }
        if (this.forceChance) {
            controller.forceChance();
        }
        if (this.noCrits) {
            controller.rules.set(BattleRuleRegistry.NO_CRITS, true);
        }
        this.setupHandler.accept(controller);
    }

    protected void handleClearingTemporaryMode(BattleEndEvent event, BattleController battleController) {
        for (PlayerParticipant player : battleController.getPlayers()) {
            player.getStorage().setInTemporaryMode(false, null, new Pokemon[0]);
            for (PixelmonWrapper pixelmonWrapper : player.controlledPokemon) {
                if (pixelmonWrapper.entity == null) continue;
                pixelmonWrapper.entity.m_6074_();
            }
        }
    }

    protected <A extends BattleEvent> void addTask(BattleController controller, Class<? extends BattleEvent> eventClass, BiConsumer<? extends BattleEvent, BattleController> task) {
        controller.addTaskAtEvent(eventClass, task);
    }

    public static BattleBuilder builder() {
        return new BattleBuilder();
    }
}

