/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles;

import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.BattleQueryPlayer;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelectionRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.EnumRulesGuiState;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleQueryPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnumBattleQueryResponse;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.CheckRulesVersionChoosePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.DisplayBattleQueryRulesPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.SetProposedRulesPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.UpdateBattleQueryRulesPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.commands.CommandSource;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class BattleQuery {
    private static ArrayList<BattleQuery> queryList = new ArrayList();
    static int index = 0;
    private BattleQueryPlayer[] players;
    public int queryIndex;
    public BattleRules battleRules = new BattleRules();

    public BattleQuery(ServerPlayer player1, PixelmonEntity pokemon1, ServerPlayer player2, PixelmonEntity pokemon2) {
        this.players = new BattleQueryPlayer[]{new BattleQueryPlayer(player1, pokemon1), new BattleQueryPlayer(player2, pokemon2)};
        this.queryIndex = index++;
        this.sendQuery();
    }

    public BattleQuery(ServerPlayer player1, Pokemon pokemon1, ServerPlayer player2, Pokemon pokemon2) {
        this.players = new BattleQueryPlayer[]{new BattleQueryPlayer(player1, pokemon1), new BattleQueryPlayer(player2, pokemon2)};
        this.queryIndex = index++;
        this.sendQuery();
    }

    private void sendQuery() {
        int i;
        PlayerPartyStorage[] storages = new PlayerPartyStorage[this.players.length];
        for (i = 0; i < this.players.length; ++i) {
            storages[i] = StorageProxy.getPartyNow(this.players[i].player);
        }
        for (i = 0; i < this.players.length; ++i) {
            int other = i == 0 ? 1 : 0;
            BattleQueryPacket packet = new BattleQueryPacket(this.queryIndex, this.players[other].player.m_20148_(), storages[other]);
            NetworkHelper.sendPacket(packet, this.players[i].player);
        }
        queryList.add(this);
    }

    public void acceptQuery(ServerPlayer player, EnumBattleQueryResponse response) {
        BattleQueryPlayer currentPlayer = null;
        for (BattleQueryPlayer queryPlayer : this.players) {
            if (player != queryPlayer.player) continue;
            queryPlayer.response = response;
            currentPlayer = queryPlayer;
            break;
        }
        if (currentPlayer == null) {
            return;
        }
        boolean allConfirm = true;
        boolean allAccept = true;
        for (BattleQueryPlayer queryPlayer : this.players) {
            if (!queryPlayer.response.isAcceptResponse()) {
                allConfirm = false;
            }
            if (queryPlayer.response == EnumBattleQueryResponse.Accept) continue;
            allAccept = false;
        }
        if (allConfirm) {
            if (allAccept) {
                this.startBattle();
            } else {
                BattleQueryPlayer proposePlayer = this.players[currentPlayer == this.players[0] ? 1 : 0];
                if (proposePlayer.response != EnumBattleQueryResponse.Rules) {
                    proposePlayer = currentPlayer;
                }
                BattleQueryPlayer otherPlayer = proposePlayer;
                for (BattleQueryPlayer queryPlayer : this.players) {
                    EnumBattleQueryResponse enumBattleQueryResponse = queryPlayer.response = queryPlayer == proposePlayer ? EnumBattleQueryResponse.Accept : EnumBattleQueryResponse.Rules;
                    if (queryPlayer == proposePlayer) continue;
                    otherPlayer = queryPlayer;
                }
                NetworkHelper.sendPacket(new CheckRulesVersionChoosePacket(new DisplayBattleQueryRulesPacket(this.queryIndex, true)), proposePlayer.player);
                NetworkHelper.sendPacket(new CheckRulesVersionChoosePacket(new DisplayBattleQueryRulesPacket(this.queryIndex, false)), otherPlayer.player);
            }
        }
    }

    private void startBattle() {
        int i;
        PartyStorage[] storages = new PartyStorage[this.players.length];
        for (i = 0; i < this.players.length; ++i) {
            storages[i] = StorageProxy.getPartyNow(this.players[i].player);
        }
        if (this.battleRules.isDefault()) {
            for (i = 0; i < storages.length; ++i) {
                BattleQueryPlayer queryPlayer = this.players[i];
                if (queryPlayer.pixelmonEntity != null) continue;
                queryPlayer.pixelmonEntity = storages[i].findOne(pokemon -> pokemon.canBattle() && !pokemon.getPixelmonEntity().isPresent()).getOrSpawnPixelmon((Entity)queryPlayer.player);
            }
            if (this.battleRules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.SINGLE) {
                this.players[0].pixelmonEntity.startBattle((BattleParticipant)this.players[0].getParticipant(), (BattleParticipant)this.players[1].getParticipant(), this.battleRules);
            } else {
                PixelmonEntity[] secondPokemon = new PixelmonEntity[this.players.length];
                boolean valid = true;
                for (int j = 0; j < secondPokemon.length; ++j) {
                    PartyStorage storage = storages[j];
                    BattleQueryPlayer player = this.players[j];
                    for (int i2 = 0; i2 < 6; ++i2) {
                        UUID pixId = null;
                        Pokemon pokemon2 = storage.get(i2);
                        pixId = storage.get(i2).getUUID();
                        if (player.pixelmonEntity.getPokemon().getUUID().equals(pixId) || !pokemon2.canBattle()) continue;
                        secondPokemon[j] = pokemon2.getOrSpawnPixelmon((Entity)player.player);
                        break;
                    }
                    if (secondPokemon[j] != null) continue;
                    ChatHandler.sendChat((CommandSource)this.players[0].player, (CommandSource)this.players[1].player, "gui.acceptdeny.invaliddouble", player.player.m_5446_());
                    valid = false;
                    break;
                }
                if (valid) {
                    this.players[0].pixelmonEntity.startBattle((BattleParticipant)this.players[0].getParticipant(secondPokemon[0]), (BattleParticipant)this.players[0].getParticipant(secondPokemon[1]), this.battleRules);
                }
            }
        } else {
            TeamSelectionRegistry.addTeamSelection(this.battleRules, false, storages);
        }
        queryList.remove(this);
    }

    public void declineQuery(ServerPlayer player) {
        boolean valid = false;
        for (BattleQueryPlayer queryPlayer : this.players) {
            if (player != queryPlayer.player) continue;
            valid = true;
            break;
        }
        if (!valid) {
            return;
        }
        for (BattleQueryPlayer queryPlayer : this.players) {
            if (player == queryPlayer.player) continue;
            queryPlayer.player.m_6915_();
        }
        ChatHandler.sendChat((CommandSource)this.players[0].player, (CommandSource)this.players[1].player, "battlequery.declined", player.m_5446_().getString());
        queryList.remove(this);
    }

    public void proposeRules(ServerPlayer player, BattleRules rules) {
        boolean valid = false;
        for (BattleQueryPlayer queryPlayer : this.players) {
            if (player != queryPlayer.player) continue;
            queryPlayer.response = EnumBattleQueryResponse.Accept;
            valid = true;
            break;
        }
        if (!valid) {
            return;
        }
        this.battleRules = rules;
        ServerPlayer otherPlayer = this.getOtherPlayer(player);
        NetworkHelper.sendPacket(new SetProposedRulesPacket(this.battleRules), otherPlayer);
        NetworkHelper.sendPacket(new UpdateBattleQueryRulesPacket(EnumRulesGuiState.WaitAccept), player);
        NetworkHelper.sendPacket(new UpdateBattleQueryRulesPacket(EnumRulesGuiState.Accept), otherPlayer);
    }

    public void changeRules(ServerPlayer player) {
        NetworkHelper.sendPacket(new UpdateBattleQueryRulesPacket(EnumRulesGuiState.Propose), player);
        NetworkHelper.sendPacket(new UpdateBattleQueryRulesPacket(EnumRulesGuiState.WaitChange), this.getOtherPlayer(player));
    }

    private ServerPlayer getOtherPlayer(ServerPlayer player) {
        return player == this.players[0].player ? this.players[1].player : this.players[0].player;
    }

    public static BattleQuery getQuery(int index) {
        for (BattleQuery aQueryList : queryList) {
            if (aQueryList.queryIndex != index) continue;
            return aQueryList;
        }
        return null;
    }

    public static BattleQuery getQuery(ServerPlayer player) {
        for (BattleQuery aQueryList : queryList) {
            for (BattleQueryPlayer queryPlayer : aQueryList.players) {
                if (queryPlayer.player != player) continue;
                return aQueryList;
            }
        }
        return null;
    }
}

