/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.world;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockCollection {
    public final Entity cause;
    public final Level world;
    public final int minX;
    public final int maxX;
    public final int minY;
    public final int maxY;
    public final int minZ;
    public final int maxZ;
    private BlockState[][][] blockData;
    private int[][][] lightData;
    private Holder[][][] biomeData;
    private int[][] heightMap;

    public BlockCollection(Entity cause, Level world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        this.cause = cause;
        this.world = world;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = Mth.m_14045_((int)minY, (int)world.m_6042_().f_156647_(), (int)(world.m_6042_().f_156647_() + world.m_6042_().f_156648_()));
        this.maxY = Mth.m_14045_((int)maxY, (int)world.m_6042_().f_156647_(), (int)(world.m_6042_().f_156647_() + world.m_6042_().f_156648_()));
        this.minZ = minZ;
        this.maxZ = maxZ;
        this.blockData = new BlockState[maxX - minX + 1][maxY - minY + 1][maxZ - minZ + 1];
        this.lightData = new int[maxX - minX + 1][maxY - minY + 1][maxZ - minZ + 1];
        this.biomeData = new Holder[maxX - minX + 1][maxY - minY + 1][maxZ - minZ + 1];
        this.heightMap = new int[maxX - minX + 1][maxZ - minZ + 1];
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(minX, minY, minZ);
        LevelChunk chunk = null;
        for (int x = 0; x < maxX - minX + 1; ++x) {
            for (int z = 0; z < maxZ - minZ + 1; ++z) {
                BlockState state;
                int chunkX = x + minX >> 4;
                int chunkZ = z + minZ >> 4;
                this.heightMap[x][z] = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, x + minX, z + minZ);
                pos.m_122178_(x + minX, 0, z + minZ);
                if (chunk == null || chunkX != chunk.m_7697_().f_45578_ || chunkZ != chunk.m_7697_().f_45579_) {
                    chunk = world.m_7726_().m_7131_(chunkX, chunkZ);
                }
                int height = this.heightMap[x][z];
                int y = this.heightMap[x][z];
                while (y > world.m_6042_().f_156647_() && (state = chunk.m_8055_((BlockPos)pos.m_122178_(x + minX, y, z + minZ))).m_60819_().m_76170_()) {
                    height = y--;
                }
                this.heightMap[x][z] = height;
                for (y = 0; y < maxY - minY + 1; ++y) {
                    if (chunk == null) {
                        this.biomeData[x][y][z] = Holder.m_205709_((Object)((Biome)ForgeRegistries.BIOMES.getValue(Biomes.f_48173_.m_135782_())));
                        continue;
                    }
                    pos.m_122178_(x + minX, y + minY, z + minZ);
                    this.biomeData[x][y][z] = world.m_204166_((BlockPos)pos);
                    this.blockData[x][y][z] = state = chunk.m_8055_((BlockPos)pos);
                    this.lightData[x][y][z] = world.m_5518_().m_75831_((BlockPos)pos, 0);
                }
            }
        }
    }

    public Block getBlock(int x, int y, int z) {
        return this.blockData[x - this.minX][y - this.minY][z - this.minZ] == null ? Blocks.f_50069_ : this.blockData[x - this.minX][y][z - this.minZ].m_60734_();
    }

    public int getLight(int x, int y, int z) {
        return this.lightData[x - this.minX][y - this.minY][z - this.minZ];
    }

    public int getHeighestBlock(int x, int z) {
        return this.heightMap[x - this.minX][z - this.minZ];
    }

    @Nullable
    public BlockState getBlockState(int x, int y, int z) {
        return this.blockData[x - this.minX][y - this.minY][z - this.minZ];
    }

    public Holder<Biome> getBiome(int x, int y, int z) {
        return this.biomeData[x - this.minX][y - this.minY][z - this.minZ];
    }
}

