/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.joml.Vector3f;

@Mod.EventBusSubscriber(modid="pixelmon", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldHelper {
    private static final Map<String, Map<Pair<Integer, Integer>, List<StructureStart>>> STRUCTURES = Maps.newConcurrentMap();
    private static final Map<String, Structure> CACHED_STRUCTURES = Maps.newConcurrentMap();

    public static Optional<Level> findLevel(String name) {
        for (ServerLevel allLevel : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
            if (!((ServerLevelData)allLevel.m_6106_()).m_5462_().equalsIgnoreCase(name)) continue;
            return Optional.ofNullable(allLevel);
        }
        return Optional.empty();
    }

    public static <T extends Entity> T getEntityByUUID(ServerLevel world, UUID uuid, Class<T> clazz) {
        return (T)world.m_8791_(uuid);
    }

    public static int getWaterDepth(BlockPos pos, Level worldObj) {
        int count = 0;
        while (worldObj.m_8055_(pos).m_60734_() == Blocks.f_49990_ || worldObj.m_8055_(pos).m_60734_() == Blocks.f_49991_) {
            pos = pos.m_7494_();
            ++count;
        }
        return count;
    }

    public static void spawnRedstoneParticle(Level world, double posX, double posY, double posZ, double r, double g, double b) {
        world.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f((float)r, (float)g, (float)b), 1.0f), posX, posY, posZ, 0.0, 0.0, 0.0);
    }

    @Nullable
    public static HitResult rayTraceEyes(LivingEntity entity, double length) {
        Vec3 startPos = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        Vec3 endPos = startPos.m_82549_(new Vec3(entity.m_20154_().f_82479_ * length, entity.m_20154_().f_82480_ * length, entity.m_20154_().f_82481_ * length));
        return entity.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)entity));
    }

    @SubscribeEvent
    public static void onLoad(ChunkEvent.Load event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        if (event.getChunk().m_6633_().isEmpty()) {
            return;
        }
        Map dimensionStructures = STRUCTURES.computeIfAbsent(((ServerLevel)event.getLevel()).m_46472_().m_135782_().toString(), unused -> Maps.newHashMap());
        List structureStarts = dimensionStructures.computeIfAbsent(Pair.of((Object)event.getChunk().m_7697_().f_45578_, (Object)event.getChunk().m_7697_().f_45579_), ___ -> Lists.newCopyOnWriteArrayList());
        structureStarts.addAll(event.getChunk().m_6633_().values());
    }

    @SubscribeEvent
    public static void onUnload(ChunkEvent.Unload event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        Map dimensionStructures = STRUCTURES.computeIfAbsent(((ServerLevel)event.getLevel()).m_46472_().m_135782_().toString(), unused -> Maps.newHashMap());
        dimensionStructures.remove(Pair.of((Object)event.getChunk().m_7697_().f_45578_, (Object)event.getChunk().m_7697_().f_45579_));
    }

    public static boolean insideStructure(ServerLevel world, String structure, BlockPos pos) {
        Structure value = CACHED_STRUCTURES.computeIfAbsent(structure.toLowerCase(Locale.ROOT), s -> (Structure)((Registry)world.m_215010_().m_220521_().m_6632_(Registries.f_256944_).get()).m_7745_(ResourceLocationHelper.of(structure)));
        if (value == null) {
            return false;
        }
        int chunkX = pos.m_123341_() >> 4;
        int chunkZ = pos.m_123343_() >> 4;
        Map dimensionStructures = STRUCTURES.computeIfAbsent(world.m_46472_().m_135782_().toString(), unused -> Maps.newHashMap());
        List structureStarts = (List)dimensionStructures.get(Pair.of((Object)chunkX, (Object)chunkZ));
        if (structureStarts == null || structureStarts.isEmpty()) {
            return false;
        }
        for (StructureStart structureStart : structureStarts) {
            if (!Objects.equals(structureStart.m_226861_(), value) || !structureStart.m_73601_().m_71051_((Vec3i)pos)) continue;
            return true;
        }
        return false;
    }

    public static List<BlockEntity> getBlockEntitiesWithinAABB(Level world, AABB aabb) {
        int j2 = Mth.m_14107_((double)((aabb.f_82288_ - 2.0) / 16.0));
        int k2 = Mth.m_14165_((double)((aabb.f_82291_ + 2.0) / 16.0));
        int l2 = Mth.m_14107_((double)((aabb.f_82290_ - 2.0) / 16.0));
        int i3 = Mth.m_14165_((double)((aabb.f_82293_ + 2.0) / 16.0));
        ArrayList list = Lists.newArrayList();
        for (int j3 = j2; j3 < k2; ++j3) {
            for (int k3 = l2; k3 < i3; ++k3) {
                if (world.m_7726_().m_62227_(j3, k3, false) == null) continue;
                list.addAll(world.m_6325_(j3, k3).m_62954_().values());
            }
        }
        return list;
    }
}

