/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class VectorHelper {
    static final Vector3f X_AXIS = new Vector3f(1.0f, 0.0f, 0.0f);
    static final Vector3f Y_AXIS = new Vector3f(0.0f, 1.0f, 0.0f);
    static final Vector3f Z_AXIS = new Vector3f(0.0f, 0.0f, 1.0f);

    public static double[] rotate(double x, double y, double radians) {
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double newX = x * cos - y * sin;
        double newY = y * cos + x * sin;
        return new double[]{newX, newY};
    }

    public static Matrix4f matrix4FromLocRot(float xl, float yl, float zl, float xr, float yr, float zr) {
        Vector3f loc = new Vector3f(xl, yl, zl);
        Matrix4f part1 = new Matrix4f();
        part1.translate((Vector3fc)loc);
        part1.rotate(zr, (Vector3fc)Z_AXIS);
        part1.rotate(yr, (Vector3fc)Y_AXIS);
        part1.rotate(xr, (Vector3fc)X_AXIS);
        return part1;
    }

    public static Matrix4f matrix4FromFloatArray(float[] vals) {
        return VectorHelper.matrix4FromLocRot(vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]);
    }

    public static Matrix4f matrix4fFromFloat(float val) {
        return VectorHelper.matrix4FromLocRot(val, val, val, val, val, val);
    }

    public static Vector4f mul(Vector4f target, float factor, Vector4f dest) {
        if (dest == null) {
            dest = new Vector4f();
        }
        dest.set(target.x() * factor, target.y() * factor, target.z() * factor, target.w() * factor);
        return dest;
    }

    public static Matrix4f mul(Matrix4f target, float factor, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        target.scale(factor);
        dest.mul((Matrix4fc)target);
        return target;
    }

    public static Vector3f getInverse(Vector3f target) {
        return new Vector3f(-target.x(), -target.y(), -target.z());
    }

    public static Vector3f Vec3fFromStrings(String x, String y, String z) {
        float xl = Float.parseFloat(x);
        float yl = Float.parseFloat(y);
        float zl = Float.parseFloat(z);
        return new Vector3f(xl, yl, zl);
    }

    public static Vector4f copyVector4f(Vector4f src) {
        return new Vector4f(src.x(), src.y(), src.z(), src.w());
    }

    public static Vector3f crossProduct(Vector3f one, Vector3f two) {
        float f = one.x();
        float f1 = one.y();
        float f2 = one.z();
        float f3 = two.x();
        float f4 = two.y();
        float f5 = two.z();
        return new Vector3f(f1 * f5 - f2 * f4, f2 * f3 - f * f5, f * f4 - f1 * f3);
    }
}

