/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class TextHelper {
    private static final String REGEX = "(&([a-f0-9k-r]))";
    private static final Pattern PATTERN = Pattern.compile("(&([a-f0-9k-r]))", 2);
    private static final Pattern COLOUR_PATTERN = Pattern.compile("&(#\\w{6}|[\\da-zA-Z])");
    public static final List<String> DENY_CHARS = Lists.newArrayList((Object[])new String[]{"%"});
    public static final Pattern DENY_PATTERN = Pattern.compile("[&\u00a7][0-9a-fk-orA-FK-OR]");
    public static final int NAME_MAX_LENGTH = 16;
    public static final Component OR_DELIMITER = Component.m_237115_((String)"pixelmon.text.delimiter.or");
    public static final Component AND_DELIMITER = Component.m_237115_((String)"pixelmon.text.delimiter.and");

    public static Component colour(String text) {
        Matcher matcher = COLOUR_PATTERN.matcher(text);
        MutableComponent textComponent = Component.m_237119_();
        ChatFormatting nextApply = null;
        int lastEnd = 0;
        TextColor lastColor = null;
        while (matcher.find()) {
            int start = matcher.start();
            String segment = text.substring(lastEnd, start);
            MutableComponent component = TextHelper.attemptAppend(textComponent, segment, lastColor);
            if (nextApply != null && component != null) {
                component.m_130940_(nextApply);
            }
            lastEnd = matcher.end();
            String colourCode = matcher.group(1);
            Optional<TextColor> colour = TextHelper.parseColour(colourCode);
            if (colour.isPresent()) {
                lastColor = colour.get();
                nextApply = null;
                continue;
            }
            ChatFormatting byCode = TextHelper.getByCode(colourCode.toCharArray()[0]);
            if (byCode != null) {
                nextApply = byCode;
                continue;
            }
            textComponent.m_7220_((Component)Component.m_237113_((String)("&" + colourCode)));
        }
        String segment = text.substring(lastEnd);
        MutableComponent iFormattableTextComponent = TextHelper.attemptAppend(textComponent, segment, lastColor);
        if (nextApply != null && iFormattableTextComponent != null) {
            iFormattableTextComponent.m_130940_(nextApply);
        }
        return iFormattableTextComponent;
    }

    public static MutableComponent attemptAppend(MutableComponent component, String segment, TextColor lastColour) {
        if (segment.isEmpty()) {
            return null;
        }
        MutableComponent appended = Component.m_237113_((String)segment);
        if (lastColour != null) {
            appended.m_6270_(Style.f_131099_.m_131148_(lastColour));
        }
        component.m_7220_((Component)appended);
        return appended;
    }

    public static Optional<TextColor> parseColour(String colourCode) {
        TextColor colour = TextColor.m_131268_((String)colourCode);
        if (colour != null) {
            return Optional.of(colour);
        }
        if (colourCode.length() > 1) {
            return Optional.empty();
        }
        ChatFormatting byCode = TextHelper.getByCode(colourCode.toCharArray()[0]);
        if (byCode == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(TextColor.m_131270_((ChatFormatting)byCode));
    }

    public static ChatFormatting getByCode(char p_211165_0_) {
        char c0 = Character.toString(p_211165_0_).toLowerCase(Locale.ROOT).charAt(0);
        switch (c0) {
            case '0': {
                return ChatFormatting.BLACK;
            }
            case '1': {
                return ChatFormatting.DARK_BLUE;
            }
            case '2': {
                return ChatFormatting.DARK_GREEN;
            }
            case '3': {
                return ChatFormatting.DARK_AQUA;
            }
            case '4': {
                return ChatFormatting.DARK_RED;
            }
            case '5': {
                return ChatFormatting.DARK_PURPLE;
            }
            case '6': {
                return ChatFormatting.GOLD;
            }
            case '7': {
                return ChatFormatting.GRAY;
            }
            case '8': {
                return ChatFormatting.DARK_GRAY;
            }
            case '9': {
                return ChatFormatting.BLUE;
            }
            case 'a': {
                return ChatFormatting.GREEN;
            }
            case 'b': {
                return ChatFormatting.AQUA;
            }
            case 'c': {
                return ChatFormatting.RED;
            }
            case 'd': {
                return ChatFormatting.LIGHT_PURPLE;
            }
            case 'e': {
                return ChatFormatting.YELLOW;
            }
            case 'f': {
                return ChatFormatting.WHITE;
            }
            case 'k': {
                return ChatFormatting.OBFUSCATED;
            }
            case 'l': {
                return ChatFormatting.BOLD;
            }
            case 'm': {
                return ChatFormatting.STRIKETHROUGH;
            }
            case 'n': {
                return ChatFormatting.UNDERLINE;
            }
            case 'o': {
                return ChatFormatting.ITALIC;
            }
            case 'r': {
                return ChatFormatting.RESET;
            }
        }
        return null;
    }

    public static Component format(String in, Object ... args) {
        for (int i = args.length; i > 0; --i) {
            in = in.replace("%" + i, String.valueOf(args[i - 1]));
        }
        return TextHelper.colour(in);
    }

    public static Component combine(Object ... components) {
        MutableComponent component = Component.m_237119_();
        for (Object object : components) {
            if (object instanceof Component) {
                component.m_7220_((Component)object);
                continue;
            }
            component.m_130946_(String.valueOf(object));
        }
        return component;
    }

    public static String format(String line) {
        Matcher matcher = PATTERN.matcher(line);
        if (matcher.find()) {
            line = line.replaceAll(REGEX, "\u00a7$2");
        }
        return line;
    }

    public static Supplier<Component> futureTranslate(ChatFormatting colour, String text, Object ... args) {
        return () -> TextHelper.translate(colour, text, args);
    }

    public static Component translate(ChatFormatting colour, String text, Object ... args) {
        return Component.m_237110_((String)text, (Object[])args).m_130940_(colour);
    }

    public static MutableComponent translate(String text, Object ... args) {
        return Component.m_237110_((String)text, (Object[])args);
    }

    public static MutableComponent translate(ChatFormatting colour, String text) {
        return Component.m_237115_((String)text).m_130940_(colour);
    }

    public static MutableComponent translate(String text) {
        return Component.m_237115_((String)text);
    }

    public static MutableComponent color(ChatFormatting colour, String str) {
        return Component.m_237113_((String)str).m_130940_(colour);
    }

    public static MutableComponent textWithShowTextHover(String str, String hover) {
        return TextHelper.textWithShowTextHover((Component)Component.m_237113_((String)str), (Component)Component.m_237113_((String)hover));
    }

    public static MutableComponent textWithShowTextHover(String str, Component hover) {
        return TextHelper.textWithShowTextHover((Component)Component.m_237113_((String)str), hover);
    }

    public static MutableComponent textWithShowTextHover(Component str, String hover) {
        return TextHelper.textWithShowTextHover(str, (Component)Component.m_237113_((String)hover));
    }

    public static MutableComponent textWithShowTextHover(Component text, Component hover) {
        return text.m_6881_().m_6270_(text.m_7383_().m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hover)));
    }

    public static MutableComponent join(List<Component> texts, Component delimiter) {
        MutableComponent result = Component.m_237119_();
        for (int i = 0; i < texts.size(); ++i) {
            boolean isLast;
            result = result.m_7220_(texts.get(i));
            boolean bl = isLast = texts.size() - 1 == i;
            if (isLast) continue;
            result = result.m_7220_(delimiter);
        }
        return result;
    }

    public static MutableComponent joinStrings(List<String> texts, Component delimiter) {
        MutableComponent result = Component.m_237119_();
        for (int i = 0; i < texts.size(); ++i) {
            boolean isLast;
            result = result.m_7220_((Component)Component.m_237113_((String)texts.get(i)));
            boolean bl = isLast = texts.size() - 1 == i;
            if (isLast) continue;
            result = result.m_7220_(delimiter);
        }
        return result;
    }

    public static MutableComponent space(int spaces) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            str.append(" ");
        }
        return Component.m_237113_((String)str.toString());
    }
}

