/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class StringHelper {
    private static final Pattern NON_ALPHANUMERIC = Pattern.compile("[^a-zA-Z0-9_]");
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long MINUTES_PER_HOUR = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;

    public static String[] findValuesAfterKeyBeforeSpace(String text, String key) {
        String[] split = text.split(key);
        if (split.length == 0 || split.length == 1) {
            return null;
        }
        ArrayList value = Lists.newArrayList();
        for (int i = 1; i < split.length; ++i) {
            value.add(StringHelper.calculateValueBeforeSpace(split[i]));
        }
        return value.toArray(new String[0]);
    }

    private static String calculateValueBeforeSpace(String text) {
        StringBuilder builder = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (Character.isSpaceChar(c)) break;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String stripSpecialCharacters(String in) {
        return NON_ALPHANUMERIC.matcher(in).replaceAll("");
    }

    public static String toID(String in) {
        return StringHelper.stripSpecialCharacters(in.toLowerCase(Locale.ROOT));
    }

    public static MutableComponent getFormattedDuration(long timeMillis) {
        return StringHelper.getFormattedDuration(timeMillis, false);
    }

    public static MutableComponent getFormattedDuration(long timeMillis, boolean fullOutWritten) {
        long seconds = TimeUnit.SECONDS.convert(timeMillis, TimeUnit.MILLISECONDS);
        long daysPart = seconds / 86400L;
        long hoursPart = seconds / 3600L % 24L;
        long minutesPart = seconds / 60L % 60L;
        long secondsPart = seconds % 60L;
        MutableComponent textComponent = Component.m_237113_((String)"");
        textComponent.m_7220_((Component)StringHelper.getPartFormatted(daysPart, "day", fullOutWritten));
        textComponent.m_7220_((Component)StringHelper.getPartFormatted(hoursPart, "hour", fullOutWritten));
        textComponent.m_7220_((Component)StringHelper.getPartFormatted(minutesPart, "minute", fullOutWritten));
        textComponent.m_7220_((Component)StringHelper.getPartFormatted(secondsPart, "second", fullOutWritten));
        return textComponent;
    }

    private static MutableComponent getPartFormatted(long amount, String translationKey, boolean fullOutWritten) {
        if (amount > 0L) {
            MutableComponent suffix;
            String translationPrefix = "pixelmon.time." + translationKey;
            if (fullOutWritten) {
                boolean plural = amount > 1L;
                suffix = Component.m_237113_((String)" ").m_7220_((Component)TextHelper.translate(plural ? translationPrefix + ".full.plural" : translationPrefix + ".full").m_7220_((Component)Component.m_237113_((String)" ")));
            } else {
                suffix = TextHelper.translate(translationPrefix);
            }
            return Component.m_237113_((String)("" + amount)).m_7220_((Component)suffix);
        }
        return Component.m_237113_((String)"");
    }

    public static String capitalizeString(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

