/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.spriteItem.UpdateSpriteItemRequestPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.SpriteItem;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpriteItemHelper {
    public static final String NDEX = "ndex";
    public static final String FORM = "form";
    public static final String GENDER = "gender";
    public static final String PALETTE = "palette";

    public static ItemStack getPhoto(PixelmonEntity pixelmon) {
        return SpriteItemHelper.getPhoto(pixelmon.getPokemon());
    }

    public static ItemStack getPhoto(Pokemon pokemon) {
        ItemStack itemStack = new ItemStack((ItemLike)PixelmonItems.pixelmon_sprite);
        CompoundTag tagCompound = new CompoundTag();
        itemStack.m_41751_(tagCompound);
        tagCompound.m_128376_(NDEX, (short)pokemon.getSpecies().getDex());
        tagCompound.m_128359_(FORM, pokemon.getForm().getName());
        tagCompound.m_128344_(GENDER, (byte)pokemon.getGender().ordinal());
        tagCompound.m_128359_(PALETTE, pokemon.getPalette().getName());
        if (pokemon.isEgg()) {
            tagCompound.m_128405_("eggCycles", pokemon.getEggCycles());
        }
        if (pokemon.getFormattedNickname() != null && !pokemon.getFormattedNickname().getString().isEmpty()) {
            tagCompound.m_128359_("Nickname", pokemon.getFormattedNickname().getString());
        }
        return itemStack;
    }

    public static ItemStack updateSprite(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof SpriteItem && stack.m_41782_() && stack.m_41783_().m_128441_(NDEX)) {
            PaletteProperties palette;
            Gender gender;
            Species species = PixelmonSpecies.fromNationalDex(Integer.valueOf(stack.m_41783_().m_128448_(NDEX)));
            if (species == null) {
                return stack;
            }
            Stats form = species.getForm(stack.m_41783_().m_128461_(FORM));
            if (form == null) {
                form = species.getDefaultForm();
                stack.m_41783_().m_128359_(FORM, form.getName());
            }
            if ((gender = Gender.values()[stack.m_41783_().m_128445_(GENDER)]) == null) {
                gender = form.getDefaultGender();
                stack.m_41783_().m_128344_(GENDER, (byte)gender.ordinal());
            }
            if ((palette = form.getGenderProperties(gender).getPalette(stack.m_41783_().m_128461_(PALETTE))) == null) {
                palette = form.getGenderProperties(gender).getDefaultPalette();
                stack.m_41783_().m_128359_(PALETTE, palette.getName());
            }
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void requestUpdate(ItemStack stack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            int position = player.m_150109_().m_36030_(stack);
            if (position == -1) {
                if (player.m_150109_().f_35975_.contains((Object)stack)) {
                    for (int i = 0; i < 4; ++i) {
                        if (!((ItemStack)player.m_150109_().f_35975_.get(i)).equals(stack)) continue;
                        position = 36 + i;
                    }
                } else if (player.m_21206_().equals(stack)) {
                    position = 40;
                }
            }
            if (position != -1) {
                NetworkHelper.sendToServer(new UpdateSpriteItemRequestPacket(position));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<Pokemon> getPokemon(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return Optional.empty();
        }
        boolean isEgg = stack.m_41783_().m_128441_("eggCycles");
        int eggCycles = isEgg ? stack.m_41783_().m_128451_("eggCycles") : -1;
        Species species = PixelmonSpecies.fromNationalDex(Integer.valueOf(stack.m_41783_().m_128448_(NDEX)));
        if (species == null) {
            return Optional.empty();
        }
        Stats form = species.getForm(stack.m_41783_().m_128461_(FORM));
        Gender gender = Gender.values()[stack.m_41783_().m_128445_(GENDER)];
        if (form == null || gender == null) {
            SpriteItemHelper.requestUpdate(stack);
            return Optional.empty();
        }
        PaletteProperties palette = form.getGenderProperties(gender).getPalette(stack.m_41783_().m_128461_(PALETTE));
        if (palette == null) {
            SpriteItemHelper.requestUpdate(stack);
            return Optional.empty();
        }
        PokemonBase base = new PokemonBase(species, form, palette, gender);
        if (isEgg) {
            base.setEggCycles(eggCycles);
        }
        return Optional.of(base.toPokemon());
    }
}

