/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.api.util.helpers.ClientRegistryHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ServerRegistryHelper;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.fml.DistExecutor;

public class RegistryHelper {
    public static boolean compareKeys(ResourceKey<?> a, ResourceKey<?> b) {
        return a.m_211136_().toString().equalsIgnoreCase(b.m_211136_().toString()) && a.m_135782_().toString().equalsIgnoreCase(b.m_135782_().toString());
    }

    public static <T> Collection<T> getAll(ResourceKey<Registry<T>> registry) {
        return RegistryHelper.registryAccess().m_175515_(registry).m_123024_().toList();
    }

    public static <T> ResourceLocation getKey(ResourceKey<Registry<T>> registry, T element) {
        return RegistryHelper.registryAccess().m_175515_(registry).m_7981_(element);
    }

    public static <T> ResourceKey<T> getKey(ResourceKey<Registry<T>> registry, String resourceLocation) {
        return RegistryHelper.getKey(registry, ResourceLocationHelper.of(resourceLocation));
    }

    public static <T> ResourceKey<T> getKey(ResourceKey<Registry<T>> registry, ResourceLocation resourceLocation) {
        return ResourceKey.m_135785_(registry, (ResourceLocation)resourceLocation);
    }

    public static <T> MutableComponent getTranslated(Holder<T> holder) {
        return Component.m_237113_((String)RegistryHelper.getTranslationKey((ResourceKey)holder.m_203543_().get()));
    }

    public static <T> MutableComponent getTranslated(ResourceKey<T> resourceKey) {
        return Component.m_237113_((String)Util.m_137492_((String)resourceKey.m_211136_().m_135815_().toLowerCase(Locale.ROOT).replace("/", "."), (ResourceLocation)resourceKey.m_135782_()));
    }

    public static <T> String getTranslationKey(Holder<T> holder) {
        return RegistryHelper.getTranslationKey((ResourceKey)holder.m_203543_().get());
    }

    public static <T> String getTranslationKey(ResourceKey<T> resourceKey) {
        return Util.m_137492_((String)resourceKey.m_211136_().m_135815_().toLowerCase(Locale.ROOT).replace("/", "."), (ResourceLocation)resourceKey.m_135782_());
    }

    public static <T> T get(ResourceKey<Registry<T>> registryKey, ResourceLocation location) {
        return RegistryHelper.get(registryKey, ResourceKey.m_135785_(registryKey, (ResourceLocation)location));
    }

    public static <T> T get(ResourceKey<Registry<T>> registryKey, ResourceKey<T> location) {
        return (T)((Registry)RegistryHelper.registryAccess().m_6632_(registryKey).get()).m_6246_(location);
    }

    public static <T> Holder<T> getHolder(ResourceKey<Registry<T>> registryKey, T element) {
        return RegistryHelper.getHolder(registryKey, RegistryHelper.getKey(registryKey, element));
    }

    public static <T> Holder<T> getHolder(ResourceKey<Registry<T>> registryKey, ResourceLocation location) {
        return RegistryHelper.getHolder(registryKey, ResourceKey.m_135785_(registryKey, (ResourceLocation)location));
    }

    public static <T> Holder<T> getHolder(ResourceKey<Registry<T>> registryKey, ResourceKey<T> location) {
        return ((Registry)RegistryHelper.registryAccess().m_6632_(registryKey).get()).m_246971_(location);
    }

    public static <T> HolderSet<T> getTag(ResourceKey<Registry<T>> registryKey, TagKey<T> location) {
        return (HolderSet)RegistryHelper.registryAccess().m_175515_(registryKey).m_203431_(location).orElseThrow();
    }

    public static RegistryAccess.Frozen registryAccess() {
        return (RegistryAccess.Frozen)DistExecutor.safeRunForDist(() -> ClientRegistryHelper::getRegistryAccess, () -> ServerRegistryHelper::getRegistryAccess);
    }
}

