/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.collect.Sets;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RandomHelper {
    private static final Random RANDOM = new Random();
    private static final RandomSource RANDOM_SOURCE = RandomSource.m_216327_();

    public static <T> T getRandomElementExcluding(T[] elements, T ... excluded) {
        T element;
        HashSet excludedSet = Sets.newHashSet((Object[])excluded);
        if (elements.length <= excluded.length && excludedSet.containsAll(Arrays.asList(elements))) {
            return null;
        }
        while (excludedSet.contains(element = RandomHelper.getRandomElementFromArray(elements))) {
        }
        return element;
    }

    public static int getRandomNumberBetween(int min, int max) {
        return RandomHelper.useRandomForNumberBetween(RandomHelper.getLegacyRandom(), min, max);
    }

    public static float getRandomNumberBetween(float min, float max) {
        return RandomHelper.useRandomForNumberBetween(RANDOM_SOURCE, min, max);
    }

    public static int[] getRandomDistinctNumbersBetween(int min, int max, int numElements) {
        int i;
        int totalNumbers = max - min + 1;
        if (numElements < 1) {
            return new int[0];
        }
        if (numElements > totalNumbers) {
            numElements = totalNumbers;
        }
        int[] randomNumbers = new int[numElements];
        ArrayList<Integer> allNumbers = new ArrayList<Integer>(totalNumbers);
        for (i = 0; i < totalNumbers; ++i) {
            allNumbers.add(min + i);
        }
        for (i = 0; i < numElements; ++i) {
            randomNumbers[i] = (Integer)RandomHelper.getRandomElementFromList(allNumbers);
            allNumbers.remove((Object)randomNumbers[i]);
        }
        return randomNumbers;
    }

    public static int useRandomForNumberBetween(Random random, int min, int max) {
        return random.nextInt(Math.max(1, max - min + 1)) + min;
    }

    public static float useRandomForNumberBetween(RandomSource random, float min, float max) {
        return random.m_188501_() * (max - min) + min;
    }

    public static <T> T getRandomElementFromList(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        int index = RANDOM.nextInt(list.size());
        return list.get(index);
    }

    @Deprecated
    public static <T> T getRandomElementFromList(Collection<T> collection) {
        return RandomHelper.getRandomElementFromCollection(collection);
    }

    public static <T> T getRandomElementFromArray(T ... array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array[RANDOM.nextInt(array.length)];
    }

    public static <T> T removeRandomElementFromList(List<T> list) {
        if (!list.isEmpty()) {
            return list.remove(RANDOM.nextInt(list.size()));
        }
        return null;
    }

    public static boolean getRandomChance(double chance) {
        return RANDOM.nextDouble() < chance;
    }

    public static boolean getRandomChance(float chance) {
        return RANDOM.nextFloat() < chance;
    }

    public static boolean getRandomChance(int chance) {
        return RandomHelper.getRandomChance((float)chance / 100.0f);
    }

    public static boolean getRandomChance() {
        return RandomHelper.getRandomChance(0.5f);
    }

    public static boolean getRandomChance(Random random, int chance) {
        return random.nextFloat() < (float)chance / 100.0f;
    }

    public static int getFortuneAmount(int fortune) {
        return fortune > 0 ? Math.max(1, RANDOM.nextInt(fortune + 2)) : 1;
    }

    public static void initXZSeed(Random random, Level world, int chunkX, int chunkZ) {
        long seed = world == null ? 0L : world.m_7062_().f_47863_;
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        seed += (long)chunkX;
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        seed += (long)chunkZ;
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        seed += (long)chunkX;
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        random.setSeed(seed += (long)chunkZ);
    }

    public static Random staticRandomWithXZSeed(Level world, int chunkX, int chunkZ) {
        RandomHelper.initXZSeed(RANDOM, world, chunkX, chunkZ);
        return RANDOM;
    }

    public static int getRandomIndexFromWeights(List<Integer> weights) {
        int totalWeight = 0;
        for (Integer weight : weights) {
            totalWeight += weight.intValue();
        }
        if (totalWeight > 0) {
            int num = RandomHelper.getRandomNumberBetween(0, totalWeight - 1);
            int sum = 0;
            for (int i = 0; i < weights.size(); ++i) {
                if (num >= (sum += weights.get(i).intValue())) continue;
                return i;
            }
        }
        return -1;
    }

    public static Color getRandomHighSaturationColor() {
        return Color.getHSBColor(RANDOM.nextFloat() * 360.0f, 1.0f, 1.0f);
    }

    public static Vec3 nextSpherePoint(double radius) {
        double theta = RANDOM.nextDouble() * 2.0 * Math.PI;
        double phi = (RANDOM.nextDouble() - 0.5) * Math.PI;
        double rad = RANDOM.nextDouble() * radius;
        double x = rad * Math.cos(theta) * Math.cos(phi);
        double y = rad * Math.sin(phi);
        double z = rad * Math.sin(theta) * Math.cos(phi);
        return new Vec3(x, y, z);
    }

    public static <T> T getRandomElementFromCollection(Collection<T> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        int index = RANDOM.nextInt(collection.size());
        if (collection instanceof List) {
            return (T)((List)collection).get(index);
        }
        Iterator<T> iterator = collection.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public static <T> T removeRandomElementFromCollection(Collection<T> collection) {
        T element = RandomHelper.getRandomElementFromCollection(collection);
        if (element != null) {
            collection.remove(element);
            return element;
        }
        return null;
    }

    public static Random getRandom() {
        return RANDOM;
    }

    public static RandomSource getMojangRandom() {
        return RANDOM_SOURCE;
    }

    public static Random getLegacyRandom() {
        return RANDOM;
    }
}

