/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;

public class QuaternionHelper {
    public static Quaternionf fromOld(float x, float y, float z, boolean degrees) {
        if (degrees) {
            x = (float)((double)x * (Math.PI / 180));
            y = (float)((double)y * (Math.PI / 180));
            z = (float)((double)z * (Math.PI / 180));
        }
        float f = Mth.m_14031_((float)(0.5f * x));
        float f1 = Mth.m_14089_((float)(0.5f * x));
        float f2 = Mth.m_14031_((float)(0.5f * y));
        float f3 = Mth.m_14089_((float)(0.5f * y));
        float f4 = Mth.m_14031_((float)(0.5f * z));
        float f5 = Mth.m_14089_((float)(0.5f * z));
        return new Quaternionf(f * f3 * f5 + f1 * f2 * f4, f1 * f2 * f5 - f * f3 * f4, f * f2 * f5 + f1 * f3 * f4, f1 * f3 * f5 - f * f2 * f4);
    }

    public static Quaternionf fromEuler(float deg, float x, float y, float z) {
        double xValue = (double)(deg * x) * (Math.PI / 180);
        double yValue = (double)(deg * y) * (Math.PI / 180);
        double zValue = (double)(deg * z) * (Math.PI / 180);
        float f = Mth.m_14031_((float)((float)(0.5 * xValue)));
        float f1 = Mth.m_14089_((float)((float)(0.5 * xValue)));
        float f2 = Mth.m_14031_((float)((float)(0.5 * yValue)));
        float f3 = Mth.m_14089_((float)((float)(0.5 * yValue)));
        float f4 = Mth.m_14031_((float)((float)(0.5 * zValue)));
        float f5 = Mth.m_14089_((float)((float)(0.5 * zValue)));
        return new Quaternionf(f * f3 * f5 + f1 * f2 * f4, f1 * f2 * f5 - f * f3 * f4, f * f2 * f5 + f1 * f3 * f4, f1 * f3 * f5 - f * f2 * f4);
    }

    public static void mulPose(PoseStack matrix, float deg, float x, float y, float z) {
        matrix.m_252781_(QuaternionHelper.fromEuler(deg, x, y, z));
    }

    public static Quaternionf multiply(Quaternionf q1, Quaternionf q2) {
        float w1 = q1.x();
        float w2 = q2.x();
        float x1 = q1.y();
        float x2 = q2.y();
        float y1 = q1.z();
        float y2 = q2.z();
        float z1 = q1.w();
        float z2 = q2.w();
        return new Quaternionf(w1 * x2 + x1 * w2 + y1 * z2 - z1 * y2, w1 * y2 - x1 * z2 + y1 * w2 + z1 * x2, w1 * z2 + x1 * y2 - y1 * x2 + z1 * w2, w1 * w2 - x1 * x2 - y1 * y2 - z1 * z2);
    }
}

