/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class PokemonHelper {
    public static boolean hasPermanentFormsOrPalettes(Pokemon pokemon) {
        if (!pokemon.getSpecies().getForms(PokemonHelper::isFormPermanent).isEmpty()) {
            return true;
        }
        return !pokemon.getGenderProperties().getPalettes(PokemonHelper::isSpecialPalette).isEmpty();
    }

    public static boolean isFormPermanent(Stats form) {
        return !form.isDefault() && !form.isTemporary();
    }

    public static boolean isSpecialPalette(PaletteProperties palette) {
        return !palette.is("none") && !palette.is("shiny");
    }

    public static MutableComponent getFullName(Pokemon pokemon) {
        return PokemonHelper.getFullName(pokemon, false);
    }

    public static MutableComponent getFullName(Pokemon pokemon, boolean useNickname) {
        MutableComponent pokeTitle = Component.m_237119_();
        if (!pokemon.isDefaultForm()) {
            pokeTitle = pokemon.getForm().getTranslatedName().m_7220_((Component)Component.m_237113_((String)" "));
        }
        if (!pokemon.isDefaultPalette()) {
            pokeTitle.m_7220_((Component)pokemon.getPalette().getTranslatedName()).m_7220_((Component)Component.m_237113_((String)" "));
        }
        if (useNickname) {
            pokeTitle.m_7220_(pokemon.getFormattedNickname());
        } else {
            pokeTitle.m_7220_((Component)pokemon.getTranslatedName());
        }
        return pokeTitle;
    }
}

