/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.pixelmonmod.pixelmon.api.recipe.QuantifiedIngredient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;

public class JsonHelper {
    public static <T> T getOrDefault(JsonObject object, String key, Class<T> type, T def, JsonDeserializationContext context) {
        if (object.has(key) && !object.get(key).isJsonNull()) {
            return (T)context.deserialize(object.get(key), type);
        }
        return def;
    }

    public static <T> JsonArray serializeList(Collection<T> collection, Function<T, JsonElement> serializer) {
        JsonArray array = new JsonArray();
        for (T element : collection) {
            array.add(serializer.apply(element));
        }
        return array;
    }

    public static <T> ImmutableList<T> deserializeList(JsonArray array, Function<JsonElement, T> deserializer) {
        ArrayList list = Lists.newArrayList();
        for (JsonElement property : array) {
            T apply = deserializer.apply(property);
            if (apply == null) continue;
            list.add(apply);
        }
        list.remove(null);
        return ImmutableList.copyOf((Collection)list);
    }

    public static NonNullList<QuantifiedIngredient> quantifiedItemsFromJson(JsonArray ingredients) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)((Pair)Ingredient.f_291570_.decode((DynamicOps)JsonOps.INSTANCE, (Object)ingredients.get(i)).get().left().get()).getFirst();
            if (ingredient.m_43947_()) continue;
            nonnulllist.add((Object)new QuantifiedIngredient(ingredient, GsonHelper.m_13824_((JsonObject)((JsonObject)ingredients.get(i)), (String)"count", (int)1)));
        }
        return nonnulllist;
    }
}

