/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.client.models.animations.EnumRotation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class EntityHelper {
    public static double getMotion(Entity entity, EnumRotation axis) {
        switch (axis) {
            case x: {
                return entity.m_20184_().f_82479_;
            }
            case y: {
                return entity.m_20184_().f_82480_;
            }
            case z: {
                return entity.m_20184_().f_82481_;
            }
        }
        return Double.NaN;
    }

    public static void setMotion(Entity entity, EnumRotation axis, double motion) {
        switch (axis) {
            case x: {
                entity.m_20334_(motion, entity.m_20184_().m_7098_(), entity.m_20184_().m_7094_());
                break;
            }
            case y: {
                entity.m_20334_(entity.m_20184_().m_7096_(), motion, entity.m_20184_().m_7094_());
                break;
            }
            case z: {
                entity.m_20334_(entity.m_20184_().m_7096_(), entity.m_20184_().m_7098_(), motion);
            }
        }
        entity.f_19864_ = true;
    }

    public static void setMotion(Entity entity, double x, double y, double z) {
        entity.m_20334_(x, y, z);
        entity.f_19864_ = true;
    }

    public static void addMotion(Entity entity, EnumRotation axis, double motion) {
        EntityHelper.setMotion(entity, axis, EntityHelper.getMotion(entity, axis) + motion);
    }

    public static void setPosition(Entity entity, EnumRotation axis, double position) {
        switch (axis) {
            case x: {
                entity.m_6034_(position, entity.m_20186_(), entity.m_20189_());
                break;
            }
            case y: {
                entity.m_6034_(entity.m_20185_(), position, entity.m_20189_());
                break;
            }
            case z: {
                entity.m_6034_(entity.m_20185_(), entity.m_20186_(), position);
            }
        }
    }

    public static <T extends Entity> List<T> getNearbyEntities(Class<T> entityType, Level world, double x, double y, double z, float radius) {
        ArrayList found = Lists.newArrayList();
        for (int cX = (int)x - (int)radius >> 4; cX < (int)x + (int)(radius + 1.0f) >> 4; ++cX) {
            for (int cY = (int)y - (int)radius >> 4; cY < (int)y + (int)(radius + 1.0f) >> 4; ++cY) {
                found.addAll(world.m_142425_(EntityTypeTest.m_156916_(entityType), new AABB(x - (double)radius, 0.0, z - (double)radius, x + (double)radius, 500.0, z + (double)radius), e -> true));
            }
        }
        return found;
    }

    public static CompoundTag getPersistentData(Player player) {
        CompoundTag data = player.getPersistentData();
        if (!data.m_128441_("PlayerPersisted")) {
            data.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        return data.m_128469_("PlayerPersisted");
    }
}

