/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DimensionHelper {
    public static void teleport(ServerPlayer entity, String dimension, double x, double y, double z) {
        DimensionHelper.teleport(entity, dimension, x, y, z, entity.m_146908_(), entity.m_146909_(), false);
    }

    public static void teleport(ServerPlayer entity, String dimension, double x, double y, double z, float yaw, float pitch) {
        DimensionHelper.teleport(entity, dimension, x, y, z, yaw, pitch, true);
    }

    public static void teleport(ServerPlayer entity, String dimension, double x, double y, double z, float yaw, float pitch, boolean safe) {
        entity.m_20334_(0.0, 0.0, 0.0);
        entity.f_19789_ = 0.0f;
        entity.f_8906_.m_9774_(x, y, z, entity.m_146908_(), entity.m_146909_());
        ResourceKey<Level> destination = DimensionHelper.getDimension(dimension);
        if (entity.m_9236_().m_46472_() != destination && entity.m_20194_() != null) {
            DimensionHelper.getWorld(destination).ifPresent(world -> {
                if (destination == DrownedWorld.WORLD) {
                    entity.getPersistentData().m_128347_("PortalX", entity.m_20185_());
                    entity.getPersistentData().m_128347_("PortalY", entity.m_20186_());
                    entity.getPersistentData().m_128347_("PortalZ", entity.m_20189_());
                    entity.getPersistentData().m_128359_("PortalD", entity.m_9236_().m_46472_().m_135782_().toString());
                }
                double[] coords = safe ? DimensionHelper.findSafeTeleportLocation(entity.m_284548_(), x, y, z) : new double[]{x, y, z};
                entity.m_8999_(world, coords[0], coords[1], coords[2], yaw, pitch);
                world.m_5594_(null, entity.m_20183_(), SoundEvents.f_12287_, SoundSource.MASTER, 0.5f, 1.0f);
            });
        }
    }

    public static BlockPos findPosition(ServerLevel level, BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = level.m_6857_();
        int i = level.m_141928_() - 1;
        BlockPos.MutableBlockPos blockpos$mutable = pos.m_122032_();
        for (BlockPos.MutableBlockPos blockpos$mutable1 : BlockPos.m_121935_((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(i, level.m_6924_(Heightmap.Types.MOTION_BLOCKING, blockpos$mutable1.m_123341_(), blockpos$mutable1.m_123343_()));
            boolean k = true;
            if (!worldborder.m_61937_((BlockPos)blockpos$mutable1) || !worldborder.m_61937_((BlockPos)blockpos$mutable1.m_122175_(direction, 1))) continue;
            blockpos$mutable1.m_122175_(direction.m_122424_(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                blockpos$mutable1.m_142448_(l);
                if (!level.m_46859_((BlockPos)blockpos$mutable1)) continue;
                int i1 = l;
                while (l > 0 && level.m_46859_((BlockPos)blockpos$mutable1.m_122173_(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                blockpos$mutable1.m_142448_(l);
                double d2 = pos.m_123331_((Vec3i)blockpos$mutable1);
                if (d0 == -1.0 || d0 > d2) {
                    d0 = d2;
                    blockpos = blockpos$mutable1.m_7949_();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = blockpos$mutable1.m_7949_();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(pos.m_123341_(), Mth.m_14045_((int)pos.m_123342_(), (int)70, (int)(level.m_141928_() - 10)), pos.m_123343_()).m_7949_();
            Direction direction1 = direction.m_122427_();
            for (int l1 = -1; l1 < 2; ++l1) {
                for (int k2 = 0; k2 < 2; ++k2) {
                    for (int i3 = -1; i3 < 3; ++i3) {
                        blockpos$mutable.m_122154_((Vec3i)blockpos, k2 * direction.m_122429_() + l1 * direction1.m_122429_(), i3, k2 * direction.m_122431_() + l1 * direction1.m_122431_());
                    }
                }
            }
        }
        for (int k1 = -1; k1 < 3; ++k1) {
            for (int i2 = -1; i2 < 4; ++i2) {
                if (k1 != -1 && k1 != 2 && i2 != -1 && i2 != 3) continue;
                blockpos$mutable.m_122154_((Vec3i)blockpos, k1 * direction.m_122429_(), i2, k1 * direction.m_122431_());
            }
        }
        for (int j2 = 0; j2 < 2; ++j2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                blockpos$mutable.m_122154_((Vec3i)blockpos, j2 * direction.m_122429_(), l2, j2 * direction.m_122431_());
            }
        }
        return blockpos.m_7949_();
    }

    public static BlockPos findLocation(ServerLevel world, ServerPlayer player, double x, double y, double z) {
        WorldBorder worldborder = world.m_6857_();
        double d0 = Math.max(-2.9999872E7, worldborder.m_61955_() + 16.0);
        double d1 = Math.max(-2.9999872E7, worldborder.m_61956_() + 16.0);
        double d2 = Math.min(2.9999872E7, worldborder.m_61957_() - 16.0);
        double d3 = Math.min(2.9999872E7, worldborder.m_61958_() - 16.0);
        BlockPos blockpos1 = new BlockPos((int)Mth.m_14008_((double)x, (double)d0, (double)d2), (int)y, (int)Mth.m_14008_((double)z, (double)d1, (double)d3));
        return DimensionHelper.findPosition(world, blockpos1, Direction.Axis.X);
    }

    public static double[] findSafeTeleportLocation(ServerLevel world, double x, double y, double z) {
        return new double[]{x, world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)x, (int)z), z};
    }

    public static ResourceKey<Level> getDimension(String dimension) {
        if (dimension.isEmpty()) {
            return null;
        }
        return DimensionHelper.getDimension(ResourceLocationHelper.of(dimension));
    }

    public static ResourceKey<Level> getDimension(ResourceLocation key) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)key);
    }

    public static Optional<ServerLevel> getWorld(ResourceKey<Level> key) {
        return Optional.ofNullable(ServerLifecycleHooks.getCurrentServer().m_129880_(key));
    }

    public static Optional<ServerLevel> getWorld(String key) {
        return DimensionHelper.getWorld(DimensionHelper.getDimension(key));
    }
}

