/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.gui.HideMouse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@Mod.EventBusSubscriber(modid="pixelmon", value={Dist.CLIENT})
public class CursorHelper {
    private static long defaultCursorPointer = -1L;
    public static final Supplier<Long> DEFAULT_CURSOR = () -> {
        if (defaultCursorPointer == -1L) {
            defaultCursorPointer = GLFW.glfwCreateStandardCursor((int)221185);
        }
        return defaultCursorPointer;
    };
    private static long crossCursorPointer = -1L;
    public static final Supplier<Long> CROSS_CURSOR = () -> {
        if (crossCursorPointer == -1L) {
            crossCursorPointer = GLFW.glfwCreateStandardCursor((int)221187);
        }
        return crossCursorPointer;
    };
    private static long handCursorPointer = -1L;
    public static final Supplier<Long> HAND_CURSOR = () -> {
        if (handCursorPointer == -1L) {
            handCursorPointer = GLFW.glfwCreateStandardCursor((int)221188);
        }
        return handCursorPointer;
    };
    private static long verticalArrowPointer = -1L;
    public static final Supplier<Long> VERTICAL_ARROW_CURSOR = () -> {
        if (verticalArrowPointer == -1L) {
            verticalArrowPointer = GLFW.glfwCreateStandardCursor((int)221190);
        }
        return verticalArrowPointer;
    };
    private static long transparentCursorPointer = -1L;
    public static final Supplier<Long> TRANSPARENT_CURSOR = () -> {
        if (transparentCursorPointer == -1L) {
            try (MemoryStack memorystack = MemoryStack.stackPush();){
                ResourceLocation resource = ResourceLocationHelper.of("pixelmon:textures/empty.png");
                InputStream stream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(resource).get()).m_215507_();
                ByteBuffer buffer = TextureUtil.readResource((InputStream)stream);
                GLFWImage.Buffer glfwBuffer = GLFWImage.mallocStack((int)1, (MemoryStack)memorystack);
                glfwBuffer.position(0);
                glfwBuffer.width(1);
                glfwBuffer.height(1);
                glfwBuffer.pixels(buffer);
                transparentCursorPointer = GLFW.glfwCreateCursor((GLFWImage)((GLFWImage)glfwBuffer.get()), (int)0, (int)0);
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Failure in setting cursor!");
                e.printStackTrace();
            }
        }
        return transparentCursorPointer;
    };
    private static long battleCursorPointer = -1L;
    public static final Supplier<Long> BATTLE_CURSOR = () -> {
        if (battleCursorPointer == -1L) {
            try (MemoryStack memorystack = MemoryStack.stackPush();){
                ResourceLocation resource = ResourceLocationHelper.of("pixelmon:textures/gui/battle/pointer.png");
                InputStream inputstream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(resource).get()).m_215507_();
                IntBuffer intbuffer = memorystack.mallocInt(1);
                IntBuffer intbuffer1 = memorystack.mallocInt(1);
                IntBuffer intbuffer2 = memorystack.mallocInt(1);
                GLFWImage.Buffer buffer = GLFWImage.mallocStack((int)1, (MemoryStack)memorystack);
                ByteBuffer bytebuffer = CursorHelper.readIconPixels(inputstream, intbuffer, intbuffer1, intbuffer2);
                if (bytebuffer == null) {
                    throw new IllegalStateException("Could not load icon: " + STBImage.stbi_failure_reason());
                }
                buffer.position(0);
                buffer.width(intbuffer.get(0));
                buffer.height(intbuffer1.get(0));
                buffer.pixels(bytebuffer);
                battleCursorPointer = GLFW.glfwCreateCursor((GLFWImage)((GLFWImage)buffer.get()), (int)0, (int)0);
                STBImage.stbi_image_free((ByteBuffer)bytebuffer);
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Failure in setting cursor!");
                e.printStackTrace();
            }
        }
        return battleCursorPointer;
    };
    private static long currentCursor = -1L;

    public static void setCursor(Supplier<Long> pointer) {
        long cursor = pointer.get();
        if (cursor == -1L) {
            return;
        }
        if (currentCursor != cursor) {
            GLFW.glfwSetCursor((long)Minecraft.m_91087_().m_91268_().m_85439_(), (long)cursor);
            currentCursor = cursor;
        }
    }

    public static void hideCursor() {
        CursorHelper.setCursor(TRANSPARENT_CURSOR);
    }

    public static void resetCursor() {
        CursorHelper.setCursor(DEFAULT_CURSOR);
    }

    @SubscribeEvent
    public static void onInitGui(ScreenEvent.Init event) {
        if (event.getScreen() instanceof HideMouse) {
            CursorHelper.hideCursor();
        }
    }

    @SubscribeEvent
    public static void onGuiOpen(ScreenEvent.Init event) {
        if (!(Minecraft.m_91087_().f_91080_ instanceof HideMouse)) {
            CursorHelper.resetCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ByteBuffer readIconPixels(InputStream p_198111_1_, IntBuffer p_198111_2_, IntBuffer p_198111_3_, IntBuffer p_198111_4_) throws IOException {
        ByteBuffer bytebuffer1;
        RenderSystem.assertInInitPhase();
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.readResource((InputStream)p_198111_1_);
            bytebuffer.rewind();
            bytebuffer1 = STBImage.stbi_load_from_memory((ByteBuffer)bytebuffer, (IntBuffer)p_198111_2_, (IntBuffer)p_198111_3_, (IntBuffer)p_198111_4_, (int)0);
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return bytebuffer1;
    }
}

