/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.primitives.Primitives;
import com.pixelmonmod.pixelmon.api.util.RegexPatterns;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.filter.RegexFilter;

public class CommonHelper {
    public static final int[] bitFilters = new int[]{1, 3, 7, 15, 31, 63, 127, 255};

    public static void ensureIndex(List<?> a, int i) {
        while (a.size() <= i) {
            a.add(null);
        }
    }

    public static <T> T set(ArrayList<T> a, T value, int index) {
        if (a.size() <= index) {
            a.add(index, value);
            return null;
        }
        return a.set(index, value);
    }

    public static <T> void insert(ArrayList<T> a, T value) {
        int nullIndex = a.indexOf(null);
        if (nullIndex == -1) {
            a.add(value);
        } else {
            a.set(nullIndex, value);
        }
    }

    public static int indexOfAbsoluteMax(Object array) throws ClassCastException {
        Number n;
        int i;
        int index = -1;
        int maxes = 0;
        Double max = null;
        for (i = 0; i < Array.getLength(array); ++i) {
            n = (Number)Array.get(array, i);
            if (max != null && !(n.doubleValue() > max)) continue;
            max = n.doubleValue();
        }
        for (i = 0; i < Array.getLength(array); ++i) {
            n = (Number)Array.get(array, i);
            if (n.doubleValue() == max.doubleValue()) {
                ++maxes;
                index = i;
            }
            if (maxes <= 1) continue;
            return -1;
        }
        return index;
    }

    public static Object[] wrapperArray(Object aprimitive) {
        if (!aprimitive.getClass().isArray()) {
            throw new IllegalArgumentException("The variable 'primitiveArray' must ACTUALLY BE AN ARRAY!");
        }
        Class cl = aprimitive.getClass().getComponentType();
        if (!cl.isPrimitive()) {
            return (Object[])aprimitive;
        }
        cl = Primitives.wrap(cl);
        Object awrapper = Array.newInstance(cl, Array.getLength(aprimitive));
        for (int i = 0; i < Array.getLength(aprimitive); ++i) {
            Array.set(awrapper, i, Array.get(aprimitive, i));
        }
        return (Object[])awrapper;
    }

    public static <K, V> Map<K, V> addEntries(Map<K, V> map, K[] keys, V[] vals) {
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], vals[i]);
        }
        return map;
    }

    public static <K, V> Map<K, V> addEntries(Map<K, V> map, Object[] kvs) {
        for (int i = 0; i < kvs.length / 2; ++i) {
            map.put(kvs[i * 2], kvs[i * 2 + 1]);
        }
        return map;
    }

    public static <V> V getIgnoreCase(Map<String, V> map, String key) {
        if (key == null) {
            return map.get(null);
        }
        for (Map.Entry<String, V> entry : map.entrySet()) {
            if (!key.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static String textInQuotes(String str) {
        return RegexPatterns.REMOVEQUOTES.matcher(str).replaceAll("$1").trim();
    }

    public static byte[] decodeInteger(int encoded, int size) {
        if (size < 1 || size > 8) {
            throw new IllegalArgumentException("Invalid value for size; must be between 1 and 8 inclusive");
        }
        byte[] decoded = new byte[32 / size];
        for (int i = 0; i < 32 / size; ++i) {
            decoded[i] = (byte)(encoded & bitFilters[size - 1]);
            encoded >>= size;
        }
        return decoded;
    }

    public static int encodeInteger(byte[] toEncode, int size) {
        if (size < 1 || size > 8) {
            throw new IllegalArgumentException("Invalid value for size; must be between 1 and 8 inclusive");
        }
        int encoded = 0;
        for (int i = 0; i < 32 / size && i < toEncode.length; ++i) {
            encoded += (toEncode[i] & bitFilters[size - 1]) << size * i;
        }
        return encoded;
    }

    public static boolean disableLogMessage(Class<?> clazz, String regex) {
        try {
            for (Field field : clazz.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().isAssignableFrom(Logger.class)) continue;
                field.setAccessible(true);
                Logger logger = (Logger)field.get(null);
                logger.addFilter((Filter)RegexFilter.createFilter((String)regex, null, (Boolean)false, (Filter.Result)Filter.Result.DENY, (Filter.Result)Filter.Result.NEUTRAL));
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

