/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IStatStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class CommandHelper {
    public static MutableComponent getHoverTextPokemon(Pokemon pokemon, int ... args) {
        MutableComponent boxString = null;
        if (args.length > 0) {
            boxString = TextHelper.textWithShowTextHover((Component)TextHelper.color(ChatFormatting.YELLOW, "[").m_7220_((Component)TextHelper.translate(ChatFormatting.YELLOW, "pixelmon.command.pokemoninfo.boxinfo")).m_7220_((Component)TextHelper.color(ChatFormatting.YELLOW, "]")), (Component)TextHelper.translate(ChatFormatting.YELLOW, "pixelmon.command.pokemoninfo.box").m_130946_(": " + args[0]).m_130946_(" ").m_7220_((Component)TextHelper.translate(ChatFormatting.YELLOW, "pixelmon.command.pokemoninfo.slot").m_130946_(": " + args[1])));
        }
        MutableComponent statString = TextHelper.textWithShowTextHover((Component)TextHelper.color(ChatFormatting.RED, "[").m_7220_((Component)TextHelper.translate(ChatFormatting.RED, "pixelmon.command.pokemoninfo.stats")).m_7220_((Component)TextHelper.color(ChatFormatting.RED, "]")), (Component)CommandHelper.getPokemonStatsHover(pokemon));
        MutableComponent evString = TextHelper.textWithShowTextHover((Component)TextHelper.color(ChatFormatting.GOLD, "[").m_7220_((Component)TextHelper.translate(ChatFormatting.GOLD, "pixelmon.command.pokemoninfo.evs")).m_7220_((Component)TextHelper.color(ChatFormatting.GOLD, "]")), (Component)CommandHelper.getStatHover(pokemon.getEVs()));
        MutableComponent ivString = TextHelper.textWithShowTextHover((Component)TextHelper.color(ChatFormatting.LIGHT_PURPLE, "[").m_7220_((Component)TextHelper.translate(ChatFormatting.LIGHT_PURPLE, "pixelmon.command.pokemoninfo.ivs")).m_7220_((Component)TextHelper.color(ChatFormatting.LIGHT_PURPLE, "]")), (Component)CommandHelper.getStatHover(pokemon.getIVs()));
        MutableComponent movesString = TextHelper.textWithShowTextHover((Component)TextHelper.color(ChatFormatting.BLUE, "[").m_7220_((Component)TextHelper.translate(ChatFormatting.BLUE, "pixelmon.command.pokemoninfo.moves")).m_7220_((Component)TextHelper.color(ChatFormatting.BLUE, "]")), (Component)CommandHelper.getMovesetHover(pokemon.getMoveset()));
        MutableComponent result = TextHelper.translate(pokemon.isShiny() ? ChatFormatting.GOLD : ChatFormatting.GREEN, pokemon.getSpecies().getTranslationKey());
        if (boxString != null) {
            result.m_130946_(" ").m_7220_((Component)boxString);
        }
        return result.m_130946_(" ").m_7220_((Component)statString).m_130946_(" ").m_7220_((Component)evString).m_130946_(" ").m_7220_((Component)ivString).m_130946_(" ").m_7220_((Component)movesString);
    }

    private static MutableComponent getStatHover(IStatStore iStatStore) {
        if (iStatStore instanceof IVStore) {
            return TextHelper.translate(ChatFormatting.DARK_PURPLE, "pixelmon.command.pokemoninfo.ivs").m_130946_("\n").m_7220_((Component)CommandHelper.getBattleStatsFormatted(iStatStore, true));
        }
        return TextHelper.translate(ChatFormatting.GOLD, "pixelmon.command.pokemoninfo.evs").m_130946_("\n").m_7220_((Component)CommandHelper.getBattleStatsFormatted(iStatStore, false));
    }

    private static MutableComponent getBattleStatsFormatted(IStatStore iStatStore, boolean isIVs) {
        StringBuilder builder = new StringBuilder();
        BattleStatsType[] statValues = BattleStatsType.getEVIVStatValues();
        for (int i = 0; i < statValues.length; ++i) {
            BattleStatsType stat = statValues[i];
            boolean hyperTrained = isIVs && ((IVStore)iStatStore).isHyperTrained(stat);
            builder.append(stat.getTranslatedName().getString()).append(": ").append(iStatStore.getStat(stat)).append(hyperTrained ? TextHelper.color(ChatFormatting.AQUA, "(31 ").m_7220_((Component)TextHelper.translate(ChatFormatting.AQUA, "pixelmon.command.pokemoninfo.hypertrained").m_130946_(")")) : "");
            if (i == statValues.length - 1) continue;
            builder.append("\n");
        }
        return Component.m_237113_((String)builder.toString()).m_130940_(isIVs ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.GOLD);
    }

    private static MutableComponent getMovesetHover(Moveset moveset) {
        StringBuilder builder = new StringBuilder();
        Attack[] attacks = moveset.attacks;
        for (int i = 0; i < attacks.length; ++i) {
            Attack attack = attacks[i];
            builder.append(Component.m_237115_((String)"pixelmon.command.pokemoninfo.move").getString()).append(" ").append(i + 1).append(": ").append(Component.m_237115_((String)(attack != null ? attack.getMove().getTranslationKey() : "pixelmon.command.pokemoninfo.none")).getString());
            if (i == attacks.length - 1) continue;
            builder.append("\n");
        }
        return Component.m_237113_((String)builder.toString()).m_130940_(ChatFormatting.BLUE);
    }

    private static MutableComponent getPokemonStatsHover(Pokemon pokemon) {
        return TextHelper.translate(ChatFormatting.AQUA, pokemon.getSpecies().getTranslationKey()).m_130946_("\n").m_7220_((Component)TextHelper.translate(ChatFormatting.AQUA, "pixelmon.command.pokemoninfo.level")).m_130946_(": ").m_130946_(pokemon.getPokemonLevel() + "\n").m_7220_((Component)TextHelper.translate(ChatFormatting.DARK_AQUA, "pixelmon.command.pokemoninfo.nature")).m_130946_(": ").m_130946_(pokemon.getNature().getTranslatedName().getString() + "\n").m_7220_((Component)TextHelper.translate(ChatFormatting.YELLOW, "pixelmon.command.pokemoninfo.growth")).m_130946_(": ").m_130946_(pokemon.getGrowth().getTranslatedName().getString() + "\n").m_7220_((Component)TextHelper.translate(ChatFormatting.GOLD, "pixelmon.command.pokemoninfo.ability")).m_130946_(": ").m_130946_(pokemon.getAbility().getTranslatedName().getString() + "\n").m_7220_((Component)TextHelper.translate(ChatFormatting.LIGHT_PURPLE, "pixelmon.command.pokemoninfo.gender")).m_130946_(": ").m_130946_(pokemon.getGender().getTranslatedName().getString() + "\n").m_7220_((Component)TextHelper.translate(ChatFormatting.DARK_PURPLE, "pixelmon.command.pokemoninfo.originaltrainer")).m_130946_(": ").m_130946_(pokemon.getOriginalTrainer() + "\n").m_7220_((Component)TextHelper.translate(ChatFormatting.RED, "pixelmon.command.pokemoninfo.item")).m_130946_(": ").m_7220_((Component)(pokemon.getHeldItem() == ItemStack.f_41583_ ? Component.m_237115_((String)"pixelmon.command.pokemoninfo.none") : pokemon.getHeldItem().m_41611_()));
    }
}

