/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.Pixelmon;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;

public class BlockHelper {
    public static final VoxelShape EMPTY_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public static <T extends BlockEntity> T findClosestTileEntity(Class<T> tileEntity, Entity entity, double range, Predicate<T> predicate) {
        Map<BlockPos, T> map = BlockHelper.findAllTileEntityWithinRange(tileEntity, entity.f_19853_, entity.m_20182_(), range, predicate);
        if (map.size() == 0) {
            return null;
        }
        Map.Entry<BlockPos, T> closest = null;
        double distance = range + 0.1;
        for (Map.Entry<BlockPos, T> entry : map.entrySet()) {
            double dis = BlockHelper.getDistance(entity, entry.getKey());
            if (!(dis < distance)) continue;
            closest = entry;
            distance = dis;
        }
        return (T)(closest == null ? null : (BlockEntity)closest.getValue());
    }

    public static <T extends BlockEntity> Map<BlockPos, T> findAllTileEntityWithinRange(Class<T> tileEntity, Entity entity, double range, Predicate<T> predicate) {
        return BlockHelper.findAllTileEntityWithinRange(tileEntity, entity.f_19853_, entity.m_20182_(), range, predicate);
    }

    public static <T extends BlockEntity> Map<BlockPos, T> findAllTileEntityWithinRange(Class<T> tileEntity, Level world, Vec3 pos, double range, Predicate<T> predicate) {
        int chunkXPos = Mth.m_14107_((double)pos.m_7096_()) >> 4;
        int chunkZPos = Mth.m_14107_((double)pos.m_7094_()) >> 4;
        int chunkRange = Math.max((int)(range / 16.0), 1) + 1;
        HashMap map = Maps.newHashMap();
        for (int x = chunkXPos - chunkRange + 1; x < chunkXPos + chunkRange; ++x) {
            for (int z = chunkZPos - chunkRange + 1; z < chunkZPos + chunkRange; ++z) {
                if (!world.m_7726_().m_5563_(x, z)) continue;
                LevelChunk chunk = world.m_6325_(x, z);
                for (BlockPos blockEntityPos : chunk.m_5928_()) {
                    BlockEntity blockEntity = chunk.m_7702_(blockEntityPos);
                    if (!tileEntity.isAssignableFrom(blockEntity.getClass())) continue;
                    BlockPos blockPos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
                    if (!(Math.sqrt(blockEntityPos.m_123331_((Vec3i)blockPos)) <= range) || predicate != null && !predicate.test(blockEntity)) continue;
                    map.put(blockEntityPos, blockEntity);
                }
            }
        }
        return map;
    }

    public static int countTileEntitiesOfType(Level world, ChunkPos pos, Class<? extends BlockEntity> clazz) {
        int count = 0;
        LevelChunk chunk = world.m_6325_(pos.f_45578_, pos.f_45579_);
        for (BlockPos blockEntityPos : chunk.m_5928_()) {
            BlockEntity te = chunk.m_7702_(blockEntityPos);
            if (!clazz.isInstance(te)) continue;
            ++count;
        }
        return count;
    }

    public static <T extends BlockEntity> T getTileEntity(Class<T> clazz, LevelReader world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null && !clazz.isInstance(te)) {
            te = world.m_7702_(pos);
            if (te != null && !clazz.isInstance(te)) {
                Pixelmon.LOGGER.info("Bad TileEntity " + pos + " expected " + clazz.getSimpleName() + " got " + te.getClass().getSimpleName());
                return null;
            }
            if (te != null && world instanceof ServerLevel) {
                te.m_6596_();
                ((ServerLevel)world).m_7726_().m_8450_(pos);
            }
        }
        try {
            return (T)te;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean validateReach(ServerPlayer player, BlockPos pos) {
        Level world = player.m_9236_();
        double dist = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_() + 3.0;
        dist *= dist;
        return world.m_46805_(pos) && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) < dist;
    }

    private static double getDistance(Entity entity, BlockPos pos) {
        return Math.sqrt(entity.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
    }

    public static void placeBed(Level world, BlockPos pos1, Direction facing, DyeColor color) {
        BlockEntity tileentity1;
        BlockPos pos2 = pos1.m_121945_(facing);
        BlockState iblockstate2 = (BlockState)((BlockState)((BlockState)Blocks.f_50028_.m_49966_().m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.FALSE)).m_61124_((Property)BedBlock.f_54117_, (Comparable)facing)).m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.FOOT);
        world.m_7731_(pos1, iblockstate2, 10);
        world.m_7731_(pos2, (BlockState)iblockstate2.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD), 10);
        BlockEntity tileentity = world.m_7702_(pos2);
        if (tileentity instanceof BedBlockEntity) {
            ((BedBlockEntity)tileentity).m_58729_(color);
        }
        if ((tileentity1 = world.m_7702_(pos1)) instanceof BedBlockEntity) {
            ((BedBlockEntity)tileentity1).m_58729_(color);
        }
        world.m_46672_(pos1, iblockstate2.m_60734_());
        world.m_46672_(pos2, iblockstate2.m_60734_());
    }

    public static <T extends Comparable<T>> Optional<T> getPropertyValue(BlockState state, Property<T> property) {
        if (!state.m_61138_(property)) {
            return Optional.empty();
        }
        return Optional.of(state.m_61143_(property));
    }
}

