/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util.helpers;

import com.pixelmonmod.pixelmon.ai.AvoidEntitiesGoal;
import com.pixelmonmod.pixelmon.ai.ExecuteActionGoal;
import com.pixelmonmod.pixelmon.ai.FlyingGoal;
import com.pixelmonmod.pixelmon.ai.FlyingPersistentGoal;
import com.pixelmonmod.pixelmon.ai.FollowTrainerGoal;
import com.pixelmonmod.pixelmon.ai.MoveTowardsBlockGoal;
import com.pixelmonmod.pixelmon.ai.MoveTowardsTargetGoal;
import com.pixelmonmod.pixelmon.ai.StareDownGoal;
import com.pixelmonmod.pixelmon.ai.SwimmingGoal;
import com.pixelmonmod.pixelmon.ai.TargetNearestGoal;
import com.pixelmonmod.pixelmon.ai.TeleportAwayGoal;
import com.pixelmonmod.pixelmon.ai.TemptGoal;
import com.pixelmonmod.pixelmon.ai.WanderGoal;
import com.pixelmonmod.pixelmon.ai.naivgator.PixelmonGroundPathNavigation;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractInteractionsEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class AIHelper {
    int i = 0;

    public void populateTasks(AbstractInteractionsEntity entity, GoalSelector tasks) {
        tasks.m_262460_(goal -> true);
        PixelmonEntity pixelmon = (PixelmonEntity)entity;
        this.initBaseAI(pixelmon, tasks);
        if (pixelmon.getSpawnLocation() == SpawnLocationType.LAND && !entity.getForm().getMovement().canFly()) {
            this.initGroundAI(pixelmon, tasks);
        } else if (entity.getForm().getMovement().canFly() && entity.getFlyingParameters() != null) {
            if (pixelmon.getSpawnLocation() == SpawnLocationType.AIR_PERSISTENT) {
                this.initFlyingPersistentAI(pixelmon, tasks);
            } else {
                this.initFlyingAI(pixelmon, tasks);
            }
        } else if (pixelmon.getSpawnLocation() == SpawnLocationType.WATER) {
            this.initSwimmingAI(pixelmon, tasks);
        } else {
            this.initGroundAI(pixelmon, tasks);
        }
    }

    public PathNavigation createNavigator(AbstractInteractionsEntity pixelmon) {
        if (!(pixelmon.getSpawnLocation() != SpawnLocationType.LAND || pixelmon.getForm().getMovement().canFly() || pixelmon.getForm().getMovement().isRideable() && pixelmon.getForm().getTypes().contains(Element.WATER))) {
            return new PixelmonGroundPathNavigation((Mob)pixelmon, pixelmon.f_19853_);
        }
        if (pixelmon.getForm().getMovement().canFly() && pixelmon.getFlyingParameters() != null) {
            if (pixelmon.getSpawnLocation() == SpawnLocationType.AIR_PERSISTENT) {
                return new FlyingPathNavigation((Mob)pixelmon, pixelmon.f_19853_);
            }
            return new FlyingPathNavigation((Mob)pixelmon, pixelmon.f_19853_);
        }
        if (pixelmon.getSpawnLocation() == SpawnLocationType.WATER) {
            return new WaterBoundPathNavigation((Mob)pixelmon, pixelmon.f_19853_);
        }
        return new PixelmonGroundPathNavigation((Mob)pixelmon, pixelmon.f_19853_);
    }

    private void initBaseAI(PixelmonEntity pixelmon, GoalSelector tasks) {
        tasks.m_25352_(1, (Goal)new StareDownGoal(pixelmon));
        tasks.m_25352_(2, (Goal)new ExecuteActionGoal((Mob)pixelmon));
        tasks.m_25352_(3, new AvoidEntitiesGoal<Player>((PathfinderMob)pixelmon, Player.class, 16.0f, 0.23f, 0.4f));
        tasks.m_25352_(4, (Goal)new MoveTowardsBlockGoal(pixelmon, 25.0f));
    }

    private void initFlyingPersistentAI(PixelmonEntity pixelmon, GoalSelector tasks) {
        tasks.m_25352_(5, (Goal)new FollowTrainerGoal(pixelmon, 1.0, 10.0f, 4.0f, true));
        tasks.m_25352_(6, (Goal)new TemptGoal((Mob)pixelmon, false));
        tasks.m_25352_(7, (Goal)new FlyingPersistentGoal(pixelmon));
    }

    private void initSwimmingAI(PixelmonEntity pixelmon, GoalSelector tasks) {
        tasks.m_25352_(5, (Goal)new FollowTrainerGoal(pixelmon, 1.0, 10.0f, 4.0f, true));
        tasks.m_25352_(6, (Goal)new TemptGoal((Mob)pixelmon, false));
        tasks.m_25352_(7, (Goal)new SwimmingGoal(pixelmon));
    }

    private void initFlyingAI(PixelmonEntity pixelmon, GoalSelector tasks) {
        tasks.m_25352_(5, (Goal)new SwimmingGoal(pixelmon));
        tasks.m_25352_(6, (Goal)new FollowTrainerGoal(pixelmon, 1.0, 10.0f, 4.0f, true));
        tasks.m_25352_(7, (Goal)new TemptGoal((Mob)pixelmon, false));
        tasks.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)pixelmon, PixelmonEntity.class, 8.0f));
        tasks.m_25352_(9, (Goal)new FlyingGoal(pixelmon));
    }

    private void initGroundAI(PixelmonEntity entity, GoalSelector tasks) {
        if (entity.getForm().getTypes().contains(Element.FIRE)) {
            if (entity.m_21573_() instanceof GroundPathNavigation) {
                entity.m_21573_().m_7008_(true);
            }
            if (entity.m_21573_() instanceof FlyingPathNavigation) {
                entity.m_21573_().m_7008_(true);
            }
        }
        if (entity.getSpecies().is(PixelmonSpecies.ABRA)) {
            tasks.m_25352_(5, (Goal)new TeleportAwayGoal(entity));
        }
        tasks.m_25352_(5, (Goal)new MoveTowardsTargetGoal((Mob)entity, 1.3));
        tasks.m_25352_(6, (Goal)new TargetNearestGoal((Mob)entity, 8.0f, false));
        tasks.m_25352_(7, (Goal)new SwimmingGoal(entity));
        tasks.m_25352_(8, (Goal)new FollowTrainerGoal(entity, 1.0, 10.0f, 4.0f, false));
        tasks.m_25352_(9, (Goal)new TemptGoal((Mob)entity, false));
        tasks.m_25352_(10, (Goal)new WanderGoal((PathfinderMob)entity));
        tasks.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)entity, PixelmonEntity.class, 8.0f));
        tasks.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)entity));
    }

    public static boolean canSeeTargetWithinFieldOfView(Mob seeker, LivingEntity target) {
        if (target == null) {
            return false;
        }
        Vec3 visionVec = seeker.m_20154_();
        Vec3 targetVec = new Vec3(target.m_20185_() - seeker.m_20185_(), target.m_20191_().f_82289_ + (double)target.m_20206_() - (seeker.m_20186_() + (double)seeker.m_20192_()), target.m_20189_() - seeker.m_20189_());
        double dotProduct = visionVec.m_82526_(targetVec = targetVec.m_82541_());
        return dotProduct > 0.1 && seeker.m_21574_().m_148306_((Entity)target);
    }
}

