/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class TargetPoint {
    private ResourceKey<Level> dimension;
    private double x;
    private double y;
    private double z;
    private double radius;

    public TargetPoint(ResourceKey<Level> dimension, double x, double y, double z, double radius) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = radius;
    }

    public TargetPoint(Level world, BlockPos pos, double radius) {
        this.dimension = world.m_46472_();
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.radius = radius;
    }

    public TargetPoint() {
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getRadius() {
        return this.radius;
    }

    public PacketDistributor.TargetPoint toMojang() {
        return new PacketDistributor.TargetPoint(this.x, this.y, this.z, this.radius, this.dimension);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeDouble(this.radius);
        buffer.m_130085_(this.dimension.m_135782_());
    }

    public void decode(FriendlyByteBuf buffer) {
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.dimension = DimensionHelper.getDimension(buffer.m_130281_());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetPoint)) {
            return false;
        }
        TargetPoint that = (TargetPoint)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && Double.compare(that.radius, this.radius) == 0 && Objects.equals(this.dimension, that.dimension);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.x, this.y, this.z, this.radius);
    }
}

