/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ResourceWithFallback {
    public static final ResourceWithFallback NONE = ResourceWithFallback.from(ResourceLocationHelper.of("pixelmon", "does_not_exist_pls"));
    public static final Codec<ResourceWithFallback> FALLBACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("resource").forGetter(o -> o.resource), (App)ResourceLocation.f_135803_.fieldOf("fallback").forGetter(o -> o.fallback)).apply((Applicative)instance, ResourceWithFallback::new));
    public static final Codec<ResourceWithFallback> FALLBACK_TEXTURE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("resource").forGetter(o -> o.resource), (App)ResourceLocation.f_135803_.fieldOf("fallback").forGetter(o -> o.fallback)).apply((Applicative)instance, (resource, fallback) -> new ResourceWithFallback((ResourceLocation)resource, (ResourceLocation)fallback).ensureTexture()));
    public static final Codec<ResourceWithFallback> CODEC = Codec.either(FALLBACK_CODEC, (Codec)Codec.STRING.xmap(s -> ResourceWithFallback.from(ResourceLocationHelper.of(s)), resource -> resource.getResource().toString())).xmap(either -> {
        if (either.left().isPresent()) {
            return (ResourceWithFallback)either.left().get();
        }
        if (either.right().isPresent()) {
            return (ResourceWithFallback)either.right().get();
        }
        return null;
    }, Either::left);
    public static final Codec<ResourceWithFallback> TEXTURE_CODEC = Codec.either(FALLBACK_TEXTURE_CODEC, (Codec)Codec.STRING.xmap(s -> ResourceWithFallback.from(ResourceLocationHelper.of(s)).ensureTexture(), resource -> resource.getResource().toString())).xmap(either -> {
        if (either.left().isPresent()) {
            return (ResourceWithFallback)either.left().get();
        }
        if (either.right().isPresent()) {
            return (ResourceWithFallback)either.right().get();
        }
        return null;
    }, Either::left);
    private ResourceLocation resource;
    private ResourceLocation fallback;
    private boolean checkedBefore = false;
    private boolean cacheExists = false;

    public static ResourceWithFallback from(ResourceLocation resource) {
        return new ResourceWithFallback(resource, resource);
    }

    public static ResourceWithFallback from(ResourceLocation resource, ResourceLocation fallback) {
        return new ResourceWithFallback(resource, fallback);
    }

    private ResourceWithFallback(ResourceLocation resource, ResourceLocation fallback) {
        this.resource = resource;
        this.fallback = fallback;
    }

    public ResourceLocation get() {
        if (Dist.CLIENT == FMLEnvironment.dist) {
            return this.clientGet();
        }
        return this.resource;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ResourceLocation clientGet() {
        if (!this.checkedBefore) {
            this.cacheExists = ClientProxy.resourceLocationExists(this.resource);
            this.checkedBefore = true;
        }
        if (this.cacheExists) {
            return this.resource;
        }
        return this.fallback;
    }

    public ResourceWithFallback ensureTexture() {
        this.resource = ResourceLocationHelper.ofTexture(this.resource);
        this.fallback = ResourceLocationHelper.ofTexture(this.fallback);
        return this;
    }

    public ResourceLocation getResource() {
        return this.resource;
    }

    public ResourceLocation getFallback() {
        return this.fallback;
    }

    public boolean usingFallback() {
        if (this.checkedBefore) {
            return !this.cacheExists;
        }
        this.clientGet();
        return !this.cacheExists;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceWithFallback that = (ResourceWithFallback)o;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.fallback, that.fallback);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.fallback);
    }

    public boolean isNone() {
        return Objects.equals(this, NONE);
    }

    public String toString() {
        return "resource=" + this.resource + ", fallback=" + this.fallback;
    }
}

