/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.export.PokemonConverterFactory;
import com.pixelmonmod.pixelmon.api.pokemon.export.exception.PokemonImportException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class PokePasteReader {
    private final BufferedReader reader;

    private PokePasteReader(BufferedReader reader) {
        this.reader = reader;
    }

    public List<String> getLines() {
        String currentLine;
        ArrayList lines = Lists.newArrayList();
        while ((currentLine = this.readLine(this.reader)) != null) {
            lines.add(currentLine);
        }
        this.closeReader();
        return lines;
    }

    public List<Pokemon> build() throws PokemonImportException {
        return PokemonConverterFactory.importText(this.getLines());
    }

    private void closeReader() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String readLine(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static PokePasteReader from(String paste) {
        URL url = PokePasteReader.getPokePasteURL(paste);
        if (url == null) {
            return null;
        }
        InputStream inputStream = PokePasteReader.getConnectionStream(url);
        if (inputStream == null) {
            return null;
        }
        return new PokePasteReader(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
    }

    @Nullable
    private static URL getPokePasteURL(String paste) {
        if (!((String)paste).toLowerCase(Locale.ROOT).endsWith("/raw")) {
            paste = (String)paste + "/raw";
        }
        try {
            return new URL((String)paste);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Nullable
    private static InputStream getConnectionStream(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    public static PokePasteReader from(File file) {
        if (file == null) {
            return null;
        }
        InputStream inputStream = PokePasteReader.getFileStream(file);
        if (inputStream == null) {
            return null;
        }
        return new PokePasteReader(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
    }

    private static InputStream getFileStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

