/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class PixelBlockSnapshot {
    public static final String PIXEL_SNAPSHOT_BLOCK_NAME = "blockName";
    public final BlockPos pos;
    public transient BlockState replacedBlock;
    private final CompoundTag nbt;
    public transient Level world;
    public final ResourceLocation blockIdentifier;

    public static PixelBlockSnapshot readFromNBT(Level newWorld, CompoundTag tag) {
        CompoundTag nbt = tag.m_128471_("hasTE") ? tag.m_128469_("tileEntity") : null;
        PixelBlockSnapshot snap = new PixelBlockSnapshot(new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z")), tag.m_128441_("blockMod") ? tag.m_128461_("blockMod") : "minecraft", tag.m_128461_(PIXEL_SNAPSHOT_BLOCK_NAME), nbt);
        snap.world = newWorld;
        return snap;
    }

    public PixelBlockSnapshot(Level world, BlockPos pos, BlockState state) {
        this.world = world;
        this.pos = pos;
        this.replacedBlock = state;
        this.blockIdentifier = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        BlockEntity te = world.m_7702_(pos);
        this.nbt = te != null ? te.m_187481_() : null;
    }

    public PixelBlockSnapshot(Level world, BlockPos pos, BlockState state, CompoundTag nbt) {
        this.world = world;
        this.pos = pos;
        this.replacedBlock = state;
        this.blockIdentifier = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        this.nbt = nbt;
    }

    public PixelBlockSnapshot(BlockPos pos, String modid, String blockName, CompoundTag nbt) {
        this.pos = pos;
        this.blockIdentifier = ResourceLocationHelper.of(modid, blockName);
        this.nbt = nbt;
    }

    public PixelBlockSnapshot(BlockPos pos, BlockState state, CompoundTag nbt) {
        this.pos = pos;
        this.blockIdentifier = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        this.nbt = nbt;
    }

    public static PixelBlockSnapshot getBlockSnapshot(Level world, BlockPos pos) {
        return new PixelBlockSnapshot(world, pos, world.m_8055_(pos));
    }

    public static PixelBlockSnapshot readFromNBT(CompoundTag tag) {
        CompoundTag nbt = tag.m_128471_("hasTE") ? null : tag.m_128469_("tileEntity");
        return new PixelBlockSnapshot(new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z")), tag.m_128441_("blockMod") ? tag.m_128461_("blockMod") : "minecraft", tag.m_128461_(PIXEL_SNAPSHOT_BLOCK_NAME), nbt);
    }

    public BlockState getCurrentBlock() {
        return this.world.m_8055_(this.pos);
    }

    public void writeToNBT(CompoundTag compound) {
        if (!this.blockIdentifier.m_135827_().equals("minecraft")) {
            compound.m_128359_("blockMod", this.blockIdentifier.m_135827_());
        }
        compound.m_128359_(PIXEL_SNAPSHOT_BLOCK_NAME, this.blockIdentifier.m_135827_());
        compound.m_128405_("x", this.pos.m_123341_());
        compound.m_128405_("y", this.pos.m_123342_());
        compound.m_128405_("z", this.pos.m_123343_());
        compound.m_128379_("hasTE", this.nbt != null);
        if (this.nbt != null) {
            compound.m_128365_("tileEntity", (Tag)this.nbt);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PixelBlockSnapshot other = (PixelBlockSnapshot)obj;
        if (!this.pos.equals((Object)other.pos)) {
            return false;
        }
        if (!(this.nbt == other.nbt || this.nbt != null && this.nbt.equals((Object)other.nbt))) {
            return false;
        }
        if (!(this.world == other.world || this.world != null && this.world.equals(other.world))) {
            return false;
        }
        return this.blockIdentifier == other.blockIdentifier || this.blockIdentifier != null && this.blockIdentifier.equals((Object)other.blockIdentifier);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.pos.m_123341_();
        hash = 73 * hash + this.pos.m_123342_();
        hash = 73 * hash + this.pos.m_123343_();
        hash = 73 * hash + (this.nbt != null ? this.nbt.hashCode() : 0);
        hash = 73 * hash + (this.world != null ? this.world.hashCode() : 0);
        hash = 73 * hash + (this.blockIdentifier != null ? this.blockIdentifier.hashCode() : 0);
        return hash;
    }

    private BlockState checkOrientation(BlockState replaced, Direction facing) {
        if (facing != Direction.EAST) {
            if (replaced.m_61138_((Property)LeverBlock.f_54117_)) {
                Direction orientation = (Direction)replaced.m_61143_((Property)LeverBlock.f_54117_);
                if (orientation == Direction.DOWN) {
                    if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                        orientation = Direction.UP;
                    }
                } else if (orientation == Direction.DOWN) {
                    if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                        orientation = Direction.UP;
                    }
                } else if (orientation == Direction.UP) {
                    if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                        orientation = Direction.DOWN;
                    }
                } else if (orientation == Direction.DOWN) {
                    if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                        orientation = Direction.UP;
                    }
                } else if (facing == Direction.SOUTH) {
                    if (orientation == Direction.EAST) {
                        orientation = Direction.SOUTH;
                    } else if (orientation == Direction.SOUTH) {
                        orientation = Direction.WEST;
                    } else if (orientation == Direction.WEST) {
                        orientation = Direction.NORTH;
                    } else if (orientation == Direction.NORTH) {
                        orientation = Direction.EAST;
                    }
                } else if (facing == Direction.WEST) {
                    if (orientation == Direction.EAST) {
                        orientation = Direction.WEST;
                    } else if (orientation == Direction.SOUTH) {
                        orientation = Direction.NORTH;
                    } else if (orientation == Direction.WEST) {
                        orientation = Direction.EAST;
                    } else if (orientation == Direction.NORTH) {
                        orientation = Direction.SOUTH;
                    }
                } else if (facing == Direction.NORTH) {
                    if (orientation == Direction.EAST) {
                        orientation = Direction.NORTH;
                    } else if (orientation == Direction.SOUTH) {
                        orientation = Direction.EAST;
                    } else if (orientation == Direction.WEST) {
                        orientation = Direction.SOUTH;
                    } else if (orientation == Direction.NORTH) {
                        orientation = Direction.WEST;
                    }
                }
                replaced = (BlockState)replaced.m_61124_((Property)LeverBlock.f_54117_, (Comparable)orientation);
            } else if (replaced.m_60734_() instanceof StandingSignBlock) {
                int rotation = (Integer)replaced.m_61143_((Property)StandingSignBlock.f_56987_);
                if (facing == Direction.WEST) {
                    rotation += 8;
                } else if (facing == Direction.SOUTH) {
                    rotation += 4;
                } else if (facing == Direction.NORTH) {
                    rotation += 12;
                }
                if (rotation > 15) {
                    rotation -= 16;
                }
                replaced = (BlockState)replaced.m_61124_((Property)StandingSignBlock.f_56987_, (Comparable)Integer.valueOf(rotation));
            } else if (replaced.m_60734_() == Blocks.f_50191_) {
                boolean east = false;
                boolean west = false;
                boolean south = false;
                boolean north = false;
                if (facing == Direction.WEST) {
                    east = (Boolean)replaced.m_61143_((Property)VineBlock.f_57837_);
                    west = (Boolean)replaced.m_61143_((Property)VineBlock.f_57835_);
                    north = (Boolean)replaced.m_61143_((Property)VineBlock.f_57836_);
                    south = (Boolean)replaced.m_61143_((Property)VineBlock.f_57834_);
                } else if (facing == Direction.SOUTH) {
                    east = (Boolean)replaced.m_61143_((Property)VineBlock.f_57834_);
                    west = (Boolean)replaced.m_61143_((Property)VineBlock.f_57836_);
                    north = (Boolean)replaced.m_61143_((Property)VineBlock.f_57837_);
                    south = (Boolean)replaced.m_61143_((Property)VineBlock.f_57835_);
                } else if (facing == Direction.NORTH) {
                    east = (Boolean)replaced.m_61143_((Property)VineBlock.f_57836_);
                    west = (Boolean)replaced.m_61143_((Property)VineBlock.f_57834_);
                    north = (Boolean)replaced.m_61143_((Property)VineBlock.f_57835_);
                    south = (Boolean)replaced.m_61143_((Property)VineBlock.f_57837_);
                }
                replaced = (BlockState)((BlockState)((BlockState)((BlockState)replaced.m_61124_((Property)VineBlock.f_57835_, (Comparable)Boolean.valueOf(east))).m_61124_((Property)VineBlock.f_57837_, (Comparable)Boolean.valueOf(west))).m_61124_((Property)VineBlock.f_57836_, (Comparable)Boolean.valueOf(south))).m_61124_((Property)VineBlock.f_57834_, (Comparable)Boolean.valueOf(north));
            } else {
                for (Property property : replaced.m_61147_()) {
                    DirectionProperty directionProperty;
                    Direction orientation;
                    if (!(property instanceof DirectionProperty) || (orientation = (Direction)replaced.m_61143_((Property)(directionProperty = (DirectionProperty)property))) == Direction.UP || orientation == Direction.DOWN) continue;
                    if (facing == Direction.WEST) {
                        replaced = (BlockState)replaced.m_61124_((Property)directionProperty, (Comparable)orientation.m_122427_().m_122427_());
                        continue;
                    }
                    if (facing == Direction.NORTH) {
                        replaced = (BlockState)replaced.m_61124_((Property)directionProperty, (Comparable)orientation.m_122428_());
                        continue;
                    }
                    if (facing != Direction.SOUTH) continue;
                    replaced = (BlockState)replaced.m_61124_((Property)directionProperty, (Comparable)orientation.m_122427_());
                }
            }
        }
        return replaced;
    }
}

