/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.pixelmonmod.pixelmon.enums.EnumEncounterMode;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class EncounterData {
    protected final EnumEncounterMode defaultMode;
    protected EnumEncounterMode mode;
    protected long lastEncounter;
    protected final Map<UUID, Long> playerEncounters = new HashMap<UUID, Long>();

    public EncounterData(EnumEncounterMode defaultMode) {
        this.defaultMode = defaultMode;
    }

    public boolean canEncounter(Player player) {
        if (this.getMode() == EnumEncounterMode.Once) {
            return this.playerEncounters.isEmpty();
        }
        if (this.getMode() == EnumEncounterMode.OncePerPlayer) {
            return !this.playerEncounters.containsKey(player.m_20148_());
        }
        if (this.getMode() == EnumEncounterMode.OncePerDay) {
            return Instant.now().getEpochSecond() - this.lastEncounter > 86400L;
        }
        if (this.getMode() == EnumEncounterMode.OncePerMCDay) {
            return player.f_19853_.m_46467_() - this.lastEncounter > 24000L;
        }
        return true;
    }

    public void registerEncounter(Player player) {
        long now = Instant.now().getEpochSecond();
        this.playerEncounters.put(player.m_20148_(), now);
        this.lastEncounter = this.getMode() == EnumEncounterMode.OncePerMCDay ? player.f_19853_.m_46467_() : now;
    }

    public void addEncounter(UUID player, long time) {
        this.playerEncounters.put(player, time);
    }

    public EnumEncounterMode getMode() {
        return this.mode != null ? this.mode : this.defaultMode;
    }

    public CompoundTag write(CompoundTag compound) {
        compound.m_128356_("lastEnc", this.lastEncounter);
        if (this.mode != null) {
            compound.m_128344_("mode", (byte)this.mode.ordinal());
        }
        ListTag list = new ListTag();
        for (Map.Entry<UUID, Long> entry : this.playerEncounters.entrySet()) {
            CompoundTag encounter = new CompoundTag();
            encounter.m_128362_("UUID", entry.getKey());
            encounter.m_128356_("time", entry.getValue().longValue());
            list.add((Object)encounter);
        }
        compound.m_128365_("encounters", (Tag)list);
        return compound;
    }

    public void read(CompoundTag compound) {
        this.lastEncounter = compound.m_128441_("lastEnc") ? compound.m_128454_("lastEnc") : 0L;
        this.mode = compound.m_128441_("mode") ? EnumEncounterMode.getFromIndex(compound.m_128445_("mode")) : null;
        this.playerEncounters.clear();
        if (compound.m_128441_("encounters")) {
            ListTag list = compound.m_128437_("encounters", 10);
            for (Tag base : list) {
                CompoundTag encounter = (CompoundTag)base;
                UUID uuid = encounter.m_128342_("UUID");
                long time = encounter.m_128454_("time");
                this.playerEncounters.put(uuid, time);
            }
        }
    }
}

