/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.trading;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.npc.NPCTraderEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.SetClientTradePairPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Event;

public class NPCTrades {
    private static final HashMap<UUID, TradePair> activeTrades = new HashMap();

    public static void updateClientTradeData(ServerPlayer player, TradePair tradePair) {
        boolean hasPokemon = false;
        PlayerPartyStorage party = StorageProxy.getPartyNow(player);
        for (Pokemon pokemon : party.getTeam()) {
            if (pokemon == null || !tradePair.exchange.matches(pokemon) || pokemon.isUntradeable()) continue;
            hasPokemon = true;
            party.retrieveAll("EntityInteract");
            break;
        }
        NetworkHelper.sendPacket(new SetClientTradePairPacket(tradePair, hasPokemon), player);
    }

    public static void showTrade(ServerPlayer player, TradePair tradePair) {
        NPCTrades.showTrade(player, tradePair, -1);
    }

    public static void showTrade(ServerPlayer player, TradePair tradePair, int trainerID) {
        NPCTraderEvent.ShowTrade.Pre pre = new NPCTraderEvent.ShowTrade.Pre((Player)player, (NPCEntity)player.f_19853_.m_6815_(trainerID), tradePair);
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            return;
        }
        NPCTrades.updateClientTradeData(player, pre.getTrade());
        activeTrades.put(player.m_20148_(), pre.getTrade());
        OpenScreenPacket.open((Player)player, EnumGuiScreen.NPCTraderGui, trainerID);
        Pixelmon.EVENT_BUS.post((Event)new NPCTraderEvent.ShowTrade.Post((Player)player, pre.getTrader(), pre.getTrade()));
    }

    @Nullable
    public static TradePair getTradePair(UUID uuid) {
        return activeTrades.get(uuid);
    }

    public static void clearTradePair(UUID uuid) {
        activeTrades.remove(uuid);
    }
}

