/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class UTurnTests {
    @BattleTest
    public static CompletableFuture<TestResult> testSwitchIsSuccessfulAfterHitAgainstSubstitute(BattleTestHelper helper) {
        TestParticipant alakazam = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ALAKAZAM).ability(AbilityRegistry.MAGIC_GUARD).moves(AttackRegistry.SUBSTITUTE).build());
        Pokemon beedrill = helper.createDefaultPokemon(PixelmonSpecies.BEEDRILL).ability(AbilityRegistry.SWARM).moves(AttackRegistry.U_TURN).build();
        Pokemon kakuna = helper.createDefaultPokemon(PixelmonSpecies.KAKUNA).ability(AbilityRegistry.SHED_SKIN).moves(AttackRegistry.HARDEN).build();
        TestParticipant switcher = helper.createParticipant(beedrill, kakuna);
        return helper.setupSingleBattleBuilder(alakazam, switcher).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                alakazam.attackSelf(1);
                switcher.attackOpponent(1);
                switcher.switchPokemon(beedrill, kakuna);
            });
            if (switcher.asWrapper().getPokemonUUID() != kakuna.getUUID()) {
                return TestResult.failure("U TURN FAILED");
            }
            return TestResult.success();
        });
    }
}

