/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SkyDropTests {
    @BattleTest
    public static CompletableFuture<TestResult> testPreventTargetAttackingWhenCaught(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build());
        TestParticipant lairon = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LAIRON).moves(AttackRegistry.TACKLE).ability(AbilityRegistry.STURDY).build());
        return helper.setupSingleBattleBuilder(aerodactyl, lairon).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                lairon.attackOpponent(1);
            });
            if (!aerodactyl.asWrapper().hasFullHealth()) {
                return TestResult.failure("Lairon attacked despite being in SkyDrop");
            }
            controller.takeFullTurn();
            if (aerodactyl.asWrapper().hasFullHealth()) {
                return TestResult.failure("Lairon wasn't able to attack after being dropped.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testPreventsSwitchWhenBeingDropped(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build());
        Pokemon beedrill = helper.createDefaultPokemon(PixelmonSpecies.BEEDRILL).ability(AbilityRegistry.SWARM).moves(AttackRegistry.U_TURN).build();
        Pokemon kakuna = helper.createDefaultPokemon(PixelmonSpecies.KAKUNA).ability(AbilityRegistry.SHED_SKIN).moves(AttackRegistry.HARDEN).build();
        TestParticipant switcher = helper.createParticipant(beedrill, kakuna);
        return helper.setupSingleBattleBuilder(aerodactyl, switcher).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                switcher.attackOpponent(1);
            });
            boolean[] canSwitch = BattleParticipant.canSwitch(switcher.asWrapper());
            if (canSwitch[0] || canSwitch[1]) {
                return TestResult.failure("Beedrill is able to switch or flee while being sky dropped");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testUserAndTargetPreventedBeingForcedOut(BattleTestHelper helper) {
        Pokemon aero = helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build();
        Pokemon machamp = helper.createDefaultPokemon(PixelmonSpecies.MACHAMP).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.CIRCLE_THROW).build();
        Pokemon kabutops = helper.createDefaultPokemon(PixelmonSpecies.KABUTOPS).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamOne = helper.createParticipant(2, aero, machamp, kabutops);
        Pokemon armaldo = helper.createDefaultPokemon(PixelmonSpecies.ARMALDO).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon aggron = helper.createDefaultPokemon(PixelmonSpecies.AGGRON).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.DRAGON_TAIL).build();
        Pokemon omastar = helper.createDefaultPokemon(PixelmonSpecies.OMASTAR).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamTwo = helper.createParticipant(2, armaldo, aggron, omastar);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackTarget(aero, 1, armaldo);
                teamOne.attackTarget(machamp, 1, armaldo);
                teamOne.switchPokemon(aero, kabutops);
                teamTwo.attackOpponent(armaldo, 1);
                teamTwo.attackTarget(aggron, 1, aero);
                teamTwo.switchPokemon(armaldo, omastar);
            });
            if (!teamOne.asWrapper((Pokemon)aero).onBattlefield || teamOne.asWrapper((Pokemon)kabutops).onBattlefield) {
                return TestResult.failure("The SkyDropper should not be able to be forced out.");
            }
            if (!teamTwo.asWrapper((Pokemon)armaldo).onBattlefield || teamTwo.asWrapper((Pokemon)omastar).onBattlefield) {
                return TestResult.failure("The SkyDropped should not be able to be forced out.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testPreventTargetFromMegaEvolvingWhileCaught(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build());
        TestParticipant absol = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ABSOL).heldItem(PixelmonItems.absolite).moves(AttackRegistry.TACKLE).build());
        return helper.setupSingleBattleBuilder(aerodactyl, absol).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                absol.attackOpponent(1);
            });
            if (!aerodactyl.asWrapper().hasFullHealth()) {
                return TestResult.failure("Absol attacked despite being in SkyDrop");
            }
            controller.takeFullTurn(absol::evolve);
            if (aerodactyl.asWrapper().hasFullHealth()) {
                return TestResult.failure("Absol wasn't able to attack after being dropped.");
            }
            if (absol.asWrapper().isMega) {
                return TestResult.failure("Absol shouldn't have been able to mega evolve while being SkyDropped.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testPreventTargetFromStanceChangeWhileCaught(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build());
        TestParticipant aegislash = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.TACKLE, AttackRegistry.KINGS_SHIELD).build());
        return helper.setupSingleBattleBuilder(aerodactyl, aegislash).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                aegislash.attackOpponent(1);
            });
            controller.takeFullTurn();
            if (!aegislash.asWrapper().getForm().isForm("blade")) {
                return TestResult.failure("Aegislash did not change when attacking after SkyDrop");
            }
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                aegislash.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                aegislash.attackSelf(2);
            });
            if (aegislash.asWrapper().getForm().isForm("shield")) {
                return TestResult.failure("Aegislash did changed when attacking during SkyDrop");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testPokemonFreedIfSkyDropperFaintsMidMove(BattleTestHelper helper) {
        Pokemon aero = helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build();
        Pokemon kyogre = helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.SHEER_COLD).build();
        TestParticipant teamOne = helper.createParticipant(2, aero, kyogre);
        Pokemon lairon = helper.createDefaultPokemon(PixelmonSpecies.LAIRON).moves(AttackRegistry.SWORDS_DANCE).build();
        Pokemon aggron = helper.createDefaultPokemon(PixelmonSpecies.AGGRON).moves(AttackRegistry.TACKLE).build();
        TestParticipant teamTwo = helper.createParticipant(2, lairon, aggron);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackTarget(aero, 1, lairon);
                teamOne.attackTarget(kyogre, 1, aero);
                teamTwo.attackSelf(lairon, 1);
                teamTwo.attackTarget(aggron, 1, lairon);
            });
            if (!teamOne.asWrapper(aero).isFainted()) {
                return TestResult.failure("The SkyDropper did not get fainted.");
            }
            if (teamTwo.asWrapper(lairon).hasStatus(StatusType.SkyDropped)) {
                return TestResult.failure("The SkyDropped Pokemon did not get released.");
            }
            if (teamTwo.asWrapper(lairon).hasFullHealth()) {
                return TestResult.failure("The freed Pokemon could not be hit by an attack.");
            }
            if (teamTwo.asWrapper(lairon).getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("The freed Pokemon did not get to use its move.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotDamageFlyingTypes(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build());
        TestParticipant salamence = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SALAMENCE).moves(AttackRegistry.TACKLE).build());
        return helper.setupSingleBattleBuilder(aerodactyl, salamence).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                salamence.attackOpponent(1);
            });
            controller.takeFullTurn();
            if (aerodactyl.asWrapper().hasFullHealth()) {
                return TestResult.failure("Lairon wasn't able to attack after being dropped.");
            }
            if (!salamence.asWrapper().hasFullHealth()) {
                return TestResult.failure("Salamence shouldn't be hurt by SkyDrop.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testOnlyMakesContactOnWayDown(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build());
        Pokemon aegislash = helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.KINGS_SHIELD).build();
        Pokemon ferrothorn = helper.createDefaultPokemon(PixelmonSpecies.FERROTHORN).ability(AbilityRegistry.IRON_BARBS).moves(AttackRegistry.IRON_DEFENSE).build();
        TestParticipant switcher = helper.createParticipant(aegislash, ferrothorn);
        return helper.setupSingleBattleBuilder(aerodactyl, switcher).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                switcher.attackSelf(1);
            });
            if (aerodactyl.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Aerodactyl made contact with King's Shield before coming down");
            }
            controller.takeFullTurn(() -> {
                switcher.switchPokemon(aegislash, ferrothorn);
                aerodactyl.attackOpponent(1);
            });
            if (!switcher.asWrapper((Pokemon)ferrothorn).onBattlefield) {
                return TestResult.failure("Ferrothorn has not switched in");
            }
            if (!switcher.asWrapper(ferrothorn).hasStatus(StatusType.SkyDropped)) {
                return TestResult.failure("Ferrothorn has not been picked up by SkyDrop");
            }
            if (!aerodactyl.asWrapper().hasFullHealth()) {
                return TestResult.failure("Aerodactyl made contact with IronBarbs before coming down");
            }
            controller.takeFullTurn(() -> switcher.attackSelf(1));
            if (aerodactyl.asWrapper().hasFullHealth()) {
                return TestResult.failure("Aerodactyl did not make contact with IronBarbs after coming down");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotWorkAgainstSubstitute(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.SKY_DROP).build());
        TestParticipant salamence = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SALAMENCE).moves(AttackRegistry.SUBSTITUTE, AttackRegistry.TACKLE).build());
        return helper.setupSingleBattleBuilder(aerodactyl, salamence).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                salamence.attackSelf(1);
            });
            if (!salamence.asWrapper().hasStatus(StatusType.Substitute)) {
                return TestResult.failure("Salamence should have a substitute.");
            }
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(2);
                salamence.attackOpponent(2);
            });
            if (aerodactyl.asWrapper().hasStatus(StatusType.SkyDropping) || salamence.asWrapper().hasStatus(StatusType.SkyDropped)) {
                return TestResult.failure("SkyDrop should have failed against Substitute.");
            }
            if (aerodactyl.asWrapper().hasFullHealth()) {
                return TestResult.failure("Aerodactyl avoided Salamence's Tackle somehow.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotWorkAgainstHeavyPokemon(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build());
        TestParticipant aggron = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AGGRON).moves(AttackRegistry.TACKLE).build());
        return helper.setupSingleBattleBuilder(aerodactyl, aggron).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                aggron.attackOpponent(1);
            });
            if (aerodactyl.asWrapper().hasStatus(StatusType.SkyDropping) || aggron.asWrapper().hasStatus(StatusType.SkyDropped)) {
                return TestResult.failure("SkyDrop should have failed against heavy pokemon.");
            }
            if (aerodactyl.asWrapper().hasFullHealth()) {
                return TestResult.failure("Aerodactyl avoided Aggron's Tackle somehow.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testFailsAgainstAlly(BattleTestHelper helper) {
        Pokemon aero = helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build();
        Pokemon kyogre = helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).moves(AttackRegistry.TACKLE).build();
        TestParticipant teamOne = helper.createParticipant(2, aero, kyogre);
        Pokemon lairon = helper.createDefaultPokemon(PixelmonSpecies.LAIRON).moves(AttackRegistry.SWORDS_DANCE).build();
        Pokemon aggron = helper.createDefaultPokemon(PixelmonSpecies.AGGRON).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamTwo = helper.createParticipant(2, lairon, aggron);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackTarget(aero, 1, kyogre);
                teamOne.attackTarget(kyogre, 1, aero);
                teamTwo.attackSelf(lairon, 1);
                teamTwo.attackTarget(aggron, 1, lairon);
            });
            if (teamOne.asWrapper(aero).hasStatus(StatusType.SkyDropping) || teamOne.asWrapper(kyogre).hasStatus(StatusType.SkyDropped)) {
                return TestResult.failure("SkyDrop should have failed against ally pokemon.");
            }
            if (teamOne.asWrapper(aero).hasFullHealth()) {
                return TestResult.failure("Aerodactyl avoided Kyogre's Tackle somehow.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testMakesMostAttacksMiss(BattleTestHelper helper) {
        Pokemon aero = helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build();
        Pokemon kyogre = helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.AQUA_JET).build();
        TestParticipant teamOne = helper.createParticipant(2, aero, kyogre);
        Pokemon charizard = helper.createDefaultPokemon(PixelmonSpecies.CHARIZARD).moves(AttackRegistry.SWORDS_DANCE).build();
        Pokemon aggron = helper.createDefaultPokemon(PixelmonSpecies.AGGRON).moves(AttackRegistry.LUCKY_CHANT, AttackRegistry.AQUA_JET).build();
        TestParticipant teamTwo = helper.createParticipant(2, charizard, aggron);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackTarget(aero, 1, charizard);
                teamOne.attackTarget(kyogre, 1, aero);
                teamTwo.attackSelf(charizard, 1);
                teamTwo.attackSelf(aggron, 1);
            });
            controller.takeFullTurn(() -> {
                teamOne.attackTarget(aero, 1, charizard);
                teamOne.attackTarget(kyogre, 2, charizard);
                teamTwo.attackSelf(charizard, 1);
                teamTwo.attackTarget(aggron, 2, aero);
            });
            if (!teamOne.asWrapper(aero).hasFullHealth()) {
                return TestResult.failure("Aerodactyl should have avoided Aggron's AquaJet.");
            }
            if (!teamTwo.asWrapper(charizard).hasFullHealth()) {
                return TestResult.failure("Charizard should have avoided Kyogre's AquaJet.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldBeCancelledByGravity(BattleTestHelper helper) {
        Pokemon aero = helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build();
        Pokemon jirachi = helper.createDefaultPokemon(PixelmonSpecies.JIRACHI).moves(AttackRegistry.GRAVITY).build();
        TestParticipant teamOne = helper.createParticipant(2, aero, jirachi);
        Pokemon lairon = helper.createDefaultPokemon(PixelmonSpecies.LAIRON).moves(AttackRegistry.SWORDS_DANCE).build();
        Pokemon aggron = helper.createDefaultPokemon(PixelmonSpecies.AGGRON).moves(AttackRegistry.TACKLE).build();
        TestParticipant teamTwo = helper.createParticipant(2, lairon, aggron);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackTarget(aero, 1, lairon);
                teamOne.attackAutoTarget(jirachi, 1);
                teamTwo.attackSelf(lairon, 1);
                teamTwo.attackTarget(aggron, 1, aero);
            });
            if (teamOne.asWrapper(aero).hasFullHealth()) {
                return TestResult.failure("Aerodactyl should have been hit by Aggron's Tackle.");
            }
            if (teamTwo.asWrapper(lairon).getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Lairon should have been able to move.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotPreventSpeedBoost(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build());
        TestParticipant mew = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).moves(AttackRegistry.SPLASH).ability(AbilityRegistry.SPEED_BOOST).build());
        return helper.setupSingleBattleBuilder(aerodactyl, mew).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                mew.attackOpponent(1);
            });
            if (mew.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != 1) {
                return TestResult.failure("SpeedBoost should continue while being SkyDropped");
            }
            controller.takeFullTurn();
            if (mew.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != 2) {
                return TestResult.failure("SpeedBoost should continue after being SkyDropped.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotAnnounceReleaseIfTargetFaintsMidMove(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build());
        Pokemon shedinja = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.WONDER_GUARD).moves(AttackRegistry.SPLASH).heldItem(PixelmonItems.sticky_barb).build();
        Pokemon kakuna = helper.createDefaultPokemon(PixelmonSpecies.KAKUNA).ability(AbilityRegistry.SHED_SKIN).moves(AttackRegistry.HARDEN).build();
        TestParticipant switcher = helper.createParticipant(shedinja, kakuna);
        return helper.setupSingleBattleBuilder(aerodactyl, switcher).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                switcher.attackOpponent(1);
                switcher.switchPokemon(shedinja, kakuna);
            });
            if (!switcher.asWrapper().getSpecies().is(PixelmonSpecies.KAKUNA)) {
                return TestResult.failure("Shedinja did not manage to switch out on fainting");
            }
            if (aerodactyl.asWrapper().hasStatus(StatusType.MultiTurn, StatusType.SkyDropping)) {
                return TestResult.failure("Aerodactyl is still attacking despite Shedinja fainting");
            }
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                switcher.attackSelf(1);
            });
            if (!switcher.asWrapper(kakuna).hasFullHealth()) {
                return TestResult.failure("Aerodactyl's SkyDrop immediately attacked Kakuna");
            }
            if (switcher.hasMessageContaining("pixelmon.effect.skydropfreed")) {
                return TestResult.failure("SkyDrop should not report 'freed' if target faints mid-move.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldIgnoreFollowMe(BattleTestHelper helper) {
        Pokemon aero = helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build();
        Pokemon jirachi = helper.createDefaultPokemon(PixelmonSpecies.JIRACHI).moves(AttackRegistry.SPLASH).build();
        TestParticipant teamOne = helper.createParticipant(2, aero, jirachi);
        Pokemon lairon = helper.createDefaultPokemon(PixelmonSpecies.LAIRON).moves(AttackRegistry.SWORDS_DANCE).build();
        Pokemon togekiss = helper.createDefaultPokemon(PixelmonSpecies.TOGEKISS).moves(AttackRegistry.FOLLOW_ME).build();
        TestParticipant teamTwo = helper.createParticipant(2, lairon, togekiss);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            teamOne.attackTarget(aero, 1, lairon);
            teamOne.attackOpponent(jirachi, 1);
            teamTwo.attackSelf(lairon, 1);
            teamTwo.attackSelf(togekiss, 1);
            controller.advanceToMoves();
            controller.doTurnLogic();
            if (!teamTwo.asWrapper(togekiss).hasStatus(StatusType.FollowMe)) {
                return TestResult.failure("Togekiss should be the center of attention.");
            }
            controller.doTurnLogic();
            if (!teamTwo.asWrapper(togekiss).hasStatus(StatusType.FollowMe)) {
                return TestResult.failure("Togekiss should still be the center of attention.");
            }
            if (teamTwo.asWrapper(togekiss).hasStatus(StatusType.SkyDropped)) {
                return TestResult.failure("Togekiss should not have been picked up by SkyDrop.");
            }
            if (!teamTwo.asWrapper(lairon).hasStatus(StatusType.SkyDropped)) {
                return TestResult.failure("Togekiss should not have been picked up by SkyDrop.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotBeBlockedByWonderGuardUntilSecondTurn(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build());
        TestParticipant shuckle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.WONDER_GUARD).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(aerodactyl, shuckle).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                shuckle.attackOpponent(1);
            });
            if (!aerodactyl.asWrapper().hasStatus(StatusType.MultiTurn, StatusType.SkyDropping)) {
                return TestResult.failure("Aerodactyl is not SkyDropping despite WonderGuard not blocking yet");
            }
            if (!shuckle.asWrapper().hasStatus(StatusType.SkyDropped)) {
                return TestResult.failure("Shuckle is not being SkyDropped despite WonderGuard not blocking yet");
            }
            if (shuckle.hasMessageContaining("wonderguard")) {
                return TestResult.failure("SkyDrop should not be blocked by WonderGuard until the second turn.");
            }
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                shuckle.attackSelf(1);
            });
            if (!shuckle.asWrapper().hasFullHealth()) {
                return TestResult.failure("Aerodactyl's SkyDrop damaged Shuckle despite WonderGuard");
            }
            if (!shuckle.hasMessageContaining("wonderguard")) {
                return TestResult.failure("SkyDrop should have been blocked by WonderGuard on the second turn.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldHitDroppedTargetDespiteAllySwitch(BattleTestHelper helper) {
        Pokemon aero = helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build();
        Pokemon jirachi = helper.createDefaultPokemon(PixelmonSpecies.JIRACHI).moves(AttackRegistry.SPLASH, AttackRegistry.DRAGON_CLAW).build();
        TestParticipant teamOne = helper.createParticipant(2, aero, jirachi);
        Pokemon lairon = helper.createDefaultPokemon(PixelmonSpecies.LAIRON).moves(AttackRegistry.SWORDS_DANCE).ability(AbilityRegistry.SHELL_ARMOUR).build();
        Pokemon togekiss = helper.createDefaultPokemon(PixelmonSpecies.TOGEKISS).moves(AttackRegistry.LUCKY_CHANT, AttackRegistry.ALLY_SWITCH).build();
        TestParticipant teamTwo = helper.createParticipant(2, lairon, togekiss);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamOne.attackTarget(aero, 1, lairon);
                teamOne.attackOpponent(jirachi, 1);
                teamTwo.attackSelf(lairon, 1);
                teamTwo.attackAutoTarget(togekiss, 1);
            });
            controller.takeFullTurn(() -> {
                teamOne.attackTarget(aero, 1, lairon);
                teamOne.attackTarget(jirachi, 2, lairon);
                teamTwo.attackSelf(lairon, 1);
                teamTwo.attackSelf(togekiss, 2);
            });
            if (!teamTwo.hasMessageContaining("allyswitch")) {
                return TestResult.failure("Togekiss should have successfully used Ally Switch.");
            }
            if (!teamTwo.asWrapper(togekiss).hasFullHealth()) {
                return TestResult.failure("Togekiss should not have been hit by SkyDrop and been immune to DragonBreath.");
            }
            if (teamTwo.asWrapper(lairon).getHealthDeficit() != 15) {
                return TestResult.failure("Lairon should only have been hit by SkyDrop and not DragonBreath.");
            }
            return TestResult.success();
        });
    }
}

