/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class GlaiveRushTests {
    @BattleTest
    public static CompletableFuture<TestResult> testGlaiveRushCausingDoubleDamageAfterUse(BattleTestHelper helper) {
        TestParticipant baxcalibur = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BAXCALIBUR).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.GLAIVE_RUSH).build());
        TestParticipant skeledirge = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SKELEDIRGE).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.SHADOW_BALL).build());
        return helper.setupSingleBattleBuilder(baxcalibur, skeledirge).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                baxcalibur.attackAuto();
                skeledirge.attackAuto();
            });
            int damage = baxcalibur.asWrapper().getHealthDeficit();
            return TestResult.damageResult(damage, 212, 252);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testGlaiveRushCausingNoMissAfterUse(BattleTestHelper helper) {
        TestParticipant baxcalibur = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BAXCALIBUR).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.GLAIVE_RUSH).build());
        TestParticipant dondozo = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DONDOZO).moves(AttackRegistry.FISSURE).build());
        return helper.setupSingleBattleBuilder(baxcalibur, dondozo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                baxcalibur.attackAuto();
                dondozo.attackAuto();
            });
            if (!baxcalibur.allPokemon[0].isFainted()) {
                return TestResult.failure("Glaive Rush should cause moves never to miss the user after use");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testGlaiveRushLastsOneTurnOnly(BattleTestHelper helper) {
        TestParticipant baxcalibur = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BAXCALIBUR).heldItem(PixelmonItems.safety_goggles).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.GLAIVE_RUSH, AttackRegistry.SHORE_UP).build());
        TestParticipant tyranitar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TYRANITAR).ability(AbilityRegistry.SAND_STREAM).moves(AttackRegistry.ICE_PUNCH).build());
        return helper.setupSingleBattleBuilder(baxcalibur, tyranitar).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                baxcalibur.attackOpponent(1);
                tyranitar.attackAuto();
            });
            int damage = baxcalibur.asWrapper().getHealthDeficit();
            if (!helper.inRange(damage, 149, 178)) {
                return TestResult.failure("Glaive Rush should cause the user to take double damage after use: " + damage);
            }
            controller.takeFullTurn(() -> {
                baxcalibur.attackSelf(2);
                tyranitar.attackAuto();
            });
            damage = baxcalibur.asWrapper().getHealthDeficit();
            if (!helper.inRange(damage, 75, 89)) {
                return TestResult.failure("Glaive Rush should not cause double damage for more than one turn: " + damage);
            }
            return TestResult.success();
        });
    }
}

