/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class FollowMeTests {
    @BattleTest
    public static CompletableFuture<TestResult> testShouldRedirectSingleTargetMovesIfValidTarget(BattleTestHelper helper) {
        Pokemon clefable = helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.FOLLOW_ME).build();
        Pokemon clefairy = helper.createDefaultPokemon(PixelmonSpecies.CLEFAIRY).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.CALM_MIND).build();
        Pokemon cleffa = helper.createDefaultPokemon(PixelmonSpecies.CLEFFA).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.CALM_MIND).build();
        TestParticipant targets = helper.createParticipant(3, clefable, clefairy, cleffa);
        Pokemon abra = helper.createDefaultPokemon(PixelmonSpecies.ABRA).ability(AbilityRegistry.SYNCHRONIZE).moves(AttackRegistry.LOW_KICK).build();
        Pokemon kadabra = helper.createDefaultPokemon(PixelmonSpecies.KADABRA).ability(AbilityRegistry.SYNCHRONIZE).moves(AttackRegistry.LOW_KICK).build();
        Pokemon alakazam = helper.createDefaultPokemon(PixelmonSpecies.ALAKAZAM).ability(AbilityRegistry.SYNCHRONIZE).moves(AttackRegistry.LOW_KICK).build();
        TestParticipant attackers = helper.createParticipant(3, abra, kadabra, alakazam);
        return helper.setupTripleBattleBuilder(targets, attackers).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                targets.attackSelf(clefable, 1);
                targets.attackSelf(clefairy, 1);
                targets.attackSelf(cleffa, 1);
                attackers.attackTarget(abra, 1, clefairy);
                attackers.attackTarget(kadabra, 1, clefairy);
                attackers.attackTarget(alakazam, 1, clefairy);
            });
            if (targets.asWrapper((Pokemon)cleffa).amountOfTimesHit != 0) {
                return TestResult.failure("Cleffa took the wrong number of hits");
            }
            if (targets.asWrapper((Pokemon)clefairy).amountOfTimesHit != 1) {
                return TestResult.failure("Clefairy took the wrong number of hits");
            }
            if (targets.asWrapper((Pokemon)clefable).amountOfTimesHit != 2) {
                return TestResult.failure("Clefable took the wrong number of hits");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotRedirectSelfTargetingMoves(BattleTestHelper helper) {
        Pokemon clefable = helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.FOLLOW_ME).build();
        Pokemon clefairy = helper.createDefaultPokemon(PixelmonSpecies.CLEFAIRY).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.CALM_MIND).build();
        TestParticipant targets = helper.createParticipant(2, clefable, clefairy);
        Pokemon abra = helper.createDefaultPokemon(PixelmonSpecies.ABRA).ability(AbilityRegistry.SYNCHRONIZE).moves(AttackRegistry.SWORDS_DANCE).build();
        Pokemon kadabra = helper.createDefaultPokemon(PixelmonSpecies.KADABRA).ability(AbilityRegistry.SYNCHRONIZE).moves(AttackRegistry.NASTY_PLOT).build();
        TestParticipant attackers = helper.createParticipant(2, abra, kadabra);
        return helper.setupDoubleBattleBuilder(targets, attackers).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                targets.attackSelf(clefable, 1);
                targets.attackSelf(clefairy, 1);
                attackers.attackSelf(abra, 1);
                attackers.attackSelf(kadabra, 1);
            });
            if (targets.asWrapper(clefable).getBattleStats().getStage(BattleStatsType.ATTACK) != 0 || attackers.asWrapper(abra).getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("SwordsDance got redirected by FollowMe");
            }
            if (targets.asWrapper(clefable).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0 || attackers.asWrapper(kadabra).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 2) {
                return TestResult.failure("NastyPlot got redirected by FollowMe");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldRedirectAsLastSlot(BattleTestHelper helper) {
        Pokemon accelgor = helper.createDefaultPokemon(PixelmonSpecies.ACCELGOR).moves(AttackRegistry.FINAL_GAMBIT).build();
        Pokemon blissey = helper.createDefaultPokemon(PixelmonSpecies.BLISSEY).moves(AttackRegistry.SOFT_BOILED, AttackRegistry.FOLLOW_ME).build();
        TestParticipant targets = helper.createParticipant(2, accelgor, blissey);
        Pokemon wynaut1 = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.TACKLE).build();
        Pokemon wynaut2 = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.TACKLE).build();
        TestParticipant attackers = helper.createParticipant(2, wynaut1, wynaut2);
        return helper.setupDoubleBattleBuilder(targets, attackers).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                targets.attackTarget(accelgor, 1, blissey);
                targets.attackSelf(blissey, 1);
                attackers.attackTarget(wynaut1, 1, blissey);
                attackers.attackTarget(wynaut2, 1, blissey);
            });
            controller.takeFullTurn(() -> {
                targets.attackSelf(blissey, 2);
                attackers.attackTarget(wynaut1, 2, wynaut2);
                attackers.attackTarget(wynaut2, 2, wynaut1);
            });
            if (targets.asWrapper((Pokemon)blissey).amountOfTimesHit != 3 || !attackers.asWrapper(wynaut1).hasFullHealth() || !attackers.asWrapper(wynaut2).hasFullHealth()) {
                return TestResult.failure("Tackles were not redirected by FollowMe");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldBlockedBySkyDrop(BattleTestHelper helper) {
        Pokemon aero = helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).moves(AttackRegistry.SKY_DROP).build();
        Pokemon jirachi = helper.createDefaultPokemon(PixelmonSpecies.JIRACHI).moves(AttackRegistry.TACKLE).build();
        TestParticipant teamOne = helper.createParticipant(2, aero, jirachi);
        Pokemon lairon = helper.createDefaultPokemon(PixelmonSpecies.LAIRON).moves(AttackRegistry.SWORDS_DANCE).build();
        Pokemon togekiss = helper.createDefaultPokemon(PixelmonSpecies.TOGEKISS).moves(AttackRegistry.FOLLOW_ME).build();
        TestParticipant teamTwo = helper.createParticipant(2, lairon, togekiss);
        return helper.setupDoubleBattleBuilder(teamOne, teamTwo).forceChance().start().thenApply(controller -> {
            teamOne.attackTarget(aero, 1, togekiss);
            teamOne.attackTarget(jirachi, 1, lairon);
            teamTwo.attackSelf(lairon, 1);
            teamTwo.attackSelf(togekiss, 1);
            controller.advanceToMoves();
            controller.doTurnLogic();
            if (!teamTwo.asWrapper(togekiss).hasStatus(StatusType.FollowMe)) {
                return TestResult.failure("Togekiss should be the center of attention.");
            }
            controller.doTurnLogic();
            if (teamTwo.asWrapper(togekiss).hasStatus(StatusType.FollowMe)) {
                return TestResult.failure("Togekiss should have lost the center of attention.");
            }
            controller.doTurnLogic();
            controller.doTurnLogic();
            if (teamTwo.asWrapper(lairon).hasFullHealth()) {
                return TestResult.failure("Togekiss's FollowMe should have ended when it got SkyDropped");
            }
            return TestResult.success();
        });
    }
}

