/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class BrickBreakTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBreaksReflect(BattleTestHelper helper) {
        TestParticipant mew = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).moves(AttackRegistry.BRICK_BREAK, AttackRegistry.SPLASH).build());
        TestParticipant ninjask = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.NINJASK).heldItem(PixelmonItems.focus_sash).moves(AttackRegistry.REFLECT, AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(mew, ninjask).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                mew.attackOpponent(2);
                ninjask.attackSelf(1);
            });
            controller.takeFullTurn(() -> {
                mew.attackOpponent(1);
                ninjask.attackOpponent(2);
            });
            if (ninjask.asWrapper().hasStatus(StatusType.Reflect)) {
                return TestResult.failure("Brick Break did not break Reflect.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotBreakReflectIfTargetIsImmune(BattleTestHelper helper) {
        TestParticipant mew = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).moves(AttackRegistry.BRICK_BREAK, AttackRegistry.SPLASH).build());
        TestParticipant gengar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GENGAR).moves(AttackRegistry.REFLECT, AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(mew, gengar).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                mew.attackOpponent(2);
                gengar.attackSelf(1);
            });
            controller.takeFullTurn(() -> {
                mew.attackOpponent(1);
                gengar.attackOpponent(2);
            });
            if (!gengar.asWrapper().hasStatus(StatusType.Reflect)) {
                return TestResult.failure("Brick Break broke Reflect despite the target being immune.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldBreakReflectIfImmunityIsIgnoredRingTarget(BattleTestHelper helper) {
        TestParticipant mew = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).moves(AttackRegistry.BRICK_BREAK, AttackRegistry.SPLASH).build());
        TestParticipant gengar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GENGAR).ability(AbilityRegistry.STURDY).heldItem(PixelmonItems.ring_target).moves(AttackRegistry.REFLECT, AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(mew, gengar).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                mew.attackOpponent(2);
                gengar.attackSelf(1);
            });
            controller.takeFullTurn(() -> {
                mew.attackOpponent(1);
                gengar.attackOpponent(2);
            });
            if (gengar.asWrapper().hasStatus(StatusType.Reflect)) {
                return TestResult.failure("Brick Break did not break Reflect despite the target's immunity being ignored.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldBreakReflectIfImmunityIsIgnoredScrappy(BattleTestHelper helper) {
        TestParticipant mew = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).ability(AbilityRegistry.SCRAPPY).moves(AttackRegistry.BRICK_BREAK, AttackRegistry.SPLASH).build());
        TestParticipant gengar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GENGAR).heldItem(PixelmonItems.focus_sash).moves(AttackRegistry.REFLECT, AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(mew, gengar).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                mew.attackOpponent(2);
                gengar.attackSelf(1);
            });
            controller.takeFullTurn(() -> {
                mew.attackOpponent(1);
                gengar.attackOpponent(2);
            });
            if (gengar.asWrapper().hasStatus(StatusType.Reflect)) {
                return TestResult.failure("Brick Break did not break Reflect despite the target's immunity being ignored.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldBreakReflectAgainstImmunityIfElectified(BattleTestHelper helper) {
        TestParticipant mew = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).ability(AbilityRegistry.STALL).moves(AttackRegistry.BRICK_BREAK, AttackRegistry.SPLASH).build());
        TestParticipant gengar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GENGAR).heldItem(PixelmonItems.focus_sash).moves(AttackRegistry.REFLECT, AttackRegistry.ELECTRIFY).build());
        return helper.setupSingleBattleBuilder(mew, gengar).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                mew.attackOpponent(2);
                gengar.attackSelf(1);
            });
            controller.takeFullTurn(() -> {
                mew.attackOpponent(1);
                gengar.attackOpponent(2);
            });
            if (gengar.asWrapper().hasStatus(StatusType.Reflect)) {
                return TestResult.failure("Brick Break did not break Reflect despite the target's immunity being removed because the move was Electrified.");
            }
            return TestResult.success();
        });
    }
}

