/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class BideTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBideDamagesSubstitute(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).level(100).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.BIDE).build());
        TestParticipant gyarados = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).level(100).moves(AttackRegistry.SUBSTITUTE, AttackRegistry.DRAGON_RAGE, AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(aerodactyl, gyarados).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                gyarados.attackSelf(1);
            });
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(2);
                gyarados.attackOpponent(2);
            });
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(2);
                gyarados.attackOpponent(2);
            });
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(2);
                gyarados.attackOpponent(3);
            });
            if (aerodactyl.asWrapper().hasStatus(StatusType.Bide)) {
                return TestResult.failure("Bide is still active.");
            }
            if (gyarados.asWrapper().hasStatus(StatusType.Substitute)) {
                return TestResult.failure("Bide did not hit through Substitute.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDamageAccumulatesAfterSwitch(BattleTestHelper helper) {
        TestParticipant aerodactyl = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.AERODACTYL).level(100).moves(AttackRegistry.BIDE).build());
        Pokemon gyarados = helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).level(100).moves(AttackRegistry.DRAGON_RAGE, AttackRegistry.SPLASH).build();
        Pokemon exeggutor = helper.createDefaultPokemon(PixelmonSpecies.EXEGGUTOR).level(100).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant switcher = helper.createParticipant(1, gyarados, exeggutor);
        return helper.setupSingleBattleBuilder(aerodactyl, switcher).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                switcher.attackOpponent(gyarados, 1);
            });
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                switcher.attackOpponent(gyarados, 2);
            });
            controller.takeFullTurn(() -> {
                aerodactyl.attackOpponent(1);
                switcher.switchPokemon(gyarados, exeggutor);
            });
            if (aerodactyl.asWrapper().hasStatus(StatusType.Bide)) {
                return TestResult.failure("Bide is still active.");
            }
            if (switcher.asWrapper(exeggutor).getHealthDeficit() != 80) {
                return TestResult.failure("Bide did not properly accumulate damage after a switch. The damage dealt was " + switcher.asWrapper(exeggutor).getHealthDeficit() + " when it should have been 80.");
            }
            return TestResult.success();
        });
    }
}

