/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class BellyDrumTests {
    @BattleTest
    public static CompletableFuture<TestResult> testCutsHPAndMaxesAttack(BattleTestHelper helper) {
        TestParticipant linoone = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LINOONE).moves(AttackRegistry.BELLY_DRUM).build());
        TestParticipant terrakion = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TERRAKION).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(linoone, terrakion).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                linoone.attackOpponent(1);
                terrakion.attackOpponent(1);
            });
            if (linoone.asWrapper().getHealth() != linoone.asWrapper().getMaxHealth() - linoone.asWrapper().getPercentMaxHealth(50.0f)) {
                return TestResult.failure("Belly Drum did not halve the user's HP. The user has " + linoone.asWrapper().getHealth() + " when it is meant to have " + (linoone.asWrapper().getMaxHealth() - linoone.asWrapper().getPercentMaxHealth(50.0f)) + ".");
            }
            if (linoone.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 6) {
                return TestResult.failure("Belly Drum did not max the user's Attack stages.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testFailsIfCanNotBeUsedWithoutFainting(BattleTestHelper helper) {
        TestParticipant linoone = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LINOONE).level(1).ability(AbilityRegistry.STURDY).moves(AttackRegistry.BELLY_DRUM).build());
        TestParticipant terrakion = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TERRAKION).level(100).moves(AttackRegistry.CLOSE_COMBAT).build());
        return helper.setupSingleBattleBuilder(linoone, terrakion).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                linoone.attackOpponent(1);
                terrakion.attackOpponent(1);
            });
            if (linoone.asWrapper().lastAttack.moveResult.result.isSuccess()) {
                return TestResult.failure("Belly Drum did not fail despite the user being below 50% HP.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldHealBeforeBellyDrum(BattleTestHelper helper) {
        TestParticipant linoone = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LINOONE).ability(AbilityRegistry.STURDY).heldItem(PixelmonItems.normalium_z).moves(AttackRegistry.BELLY_DRUM).build());
        TestParticipant rattata = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RATTATA).moves(AttackRegistry.QUICK_ATTACK).build());
        return helper.setupSingleBattleBuilder(linoone, rattata).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                linoone.attackOpponent(1);
                linoone.useZMove();
                rattata.attackOpponent(1);
            });
            if ((double)linoone.asWrapper().getHealth() != Math.ceil((double)linoone.asWrapper().getMaxHealth() / 2.0)) {
                return TestResult.failure("Z-Belly Drum did not heal the user to 100% before cutting HP.");
            }
            if (linoone.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 6) {
                return TestResult.failure("Z-Belly Drum did not max the user's Attack.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSucceedsEvenIfCanNotBeUsedWithoutFainting(BattleTestHelper helper) {
        TestParticipant linoone = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LINOONE).level(1).ability(AbilityRegistry.STURDY).heldItem(PixelmonItems.normalium_z).moves(AttackRegistry.BELLY_DRUM).build());
        TestParticipant terrakion = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TERRAKION).level(100).moves(AttackRegistry.CLOSE_COMBAT).build());
        return helper.setupSingleBattleBuilder(linoone, terrakion).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                linoone.attackOpponent(1);
                linoone.useZMove();
                terrakion.attackOpponent(1);
            });
            if (!linoone.asWrapper().lastAttack.moveResult.result.isSuccess() || linoone.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 6 || linoone.asWrapper().getHealthPercent() != 50.0f) {
                return TestResult.failure("Z-Belly Drum failed while the user was below 50% HP.");
            }
            return TestResult.success();
        });
    }
}

