/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class BelchTests {
    @BattleTest
    public static CompletableFuture<TestResult> testFailsUnlessBerryHasBeenConsumed(BattleTestHelper helper) {
        TestParticipant gulpin = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GULPIN).heldItem(PixelmonItems.lum_berry).ability(AbilityRegistry.STURDY).moves(AttackRegistry.BELCH, AttackRegistry.GLARE).build());
        TestParticipant swalot = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SWALOT).heldItem(PixelmonItems.lum_berry).ability(AbilityRegistry.STURDY).moves(AttackRegistry.BELCH, AttackRegistry.GLARE).build());
        return helper.setupSingleBattleBuilder(gulpin, swalot).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                gulpin.attackOpponent(1);
                swalot.attackOpponent(1);
            });
            if (gulpin.asWrapper().lastAttack.moveResult.result.isSuccess() || swalot.asWrapper().lastAttack.moveResult.result.isSuccess()) {
                return TestResult.failure("Belch succeeded when the user had not yet consumed a berry.");
            }
            controller.takeFullTurn(() -> {
                gulpin.attackOpponent(2);
                swalot.attackOpponent(2);
            });
            controller.takeFullTurn(() -> {
                gulpin.attackOpponent(1);
                swalot.attackOpponent(1);
            });
            if (!gulpin.asWrapper().lastAttack.moveResult.result.isSuccess() || !swalot.asWrapper().lastAttack.moveResult.result.isSuccess()) {
                return TestResult.failure("Belch failed despite the user having consumed a berry.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldSucceedIfBerryConsumedByBugBite(BattleTestHelper helper) {
        TestParticipant gulpin = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GULPIN).heldItem(PixelmonItems.lum_berry).ability(AbilityRegistry.STURDY).moves(AttackRegistry.BUG_BITE, AttackRegistry.BELCH, AttackRegistry.SLEEP_TALK).build());
        TestParticipant swalot = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SWALOT).heldItem(PixelmonItems.lum_berry).ability(AbilityRegistry.STURDY).moves(AttackRegistry.PLUCK, AttackRegistry.BELCH, AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(gulpin, swalot).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                gulpin.attackOpponent(1);
                swalot.attackOpponent(3);
            });
            controller.takeFullTurn(() -> {
                gulpin.attackOpponent(2);
                swalot.attackOpponent(2);
            });
            if (!gulpin.asWrapper().lastAttack.moveResult.result.isSuccess()) {
                return TestResult.failure("Belch failed despite the user having consumed the opponent's berry and not its own.");
            }
            if (swalot.asWrapper().lastAttack.moveResult.result.isSuccess()) {
                return TestResult.failure("Belch succeeded despite the user having its berry consumed by the opponent's Bug Bite.");
            }
            controller.takeFullTurn(() -> {
                gulpin.attackOpponent(3);
                swalot.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                gulpin.attackOpponent(3);
                swalot.attackOpponent(2);
            });
            if (!swalot.asWrapper().lastAttack.moveResult.result.isSuccess()) {
                return TestResult.failure("Belch failed despite the user having Plucked its opponents berry.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldSucceedIfBerryWasFlung(BattleTestHelper helper) {
        TestParticipant gulpin = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GULPIN).ability(AbilityRegistry.STURDY).moves(AttackRegistry.BELCH).build());
        TestParticipant swalot = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SWALOT).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.FLING).build());
        return helper.setupSingleBattleBuilder(gulpin, swalot).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                gulpin.attackOpponent(1);
                swalot.attackOpponent(1);
            });
            if (!gulpin.asWrapper().lastAttack.moveResult.result.isSuccess()) {
                return TestResult.failure("Belch failed despite the user having eaten a flung berry.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldStillBeConsumedAfterSwitch(BattleTestHelper helper) {
        Pokemon gulpin = helper.createDefaultPokemon(PixelmonSpecies.GULPIN).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.BELCH).build();
        Pokemon magikarp = helper.createMagikarp().build();
        TestParticipant switcher = helper.createParticipant(2, gulpin, magikarp);
        TestParticipant swalot = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SWALOT).ability(AbilityRegistry.STURDY).moves(AttackRegistry.SPORE, AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(switcher, swalot).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                switcher.attackOpponent(gulpin, 1);
                swalot.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                switcher.switchPokemon(gulpin, magikarp);
                swalot.attackOpponent(2);
            });
            controller.takeFullTurn(() -> {
                switcher.switchPokemon(magikarp, gulpin);
                swalot.attackOpponent(2);
            });
            controller.takeFullTurn(() -> {
                switcher.attackOpponent(gulpin, 2);
                swalot.attackOpponent(2);
            });
            if (!switcher.asWrapper((Pokemon)gulpin).lastAttack.moveResult.result.isSuccess()) {
                return TestResult.failure("Belch failed after switching out despite the user having used its berry before switching out.");
            }
            return TestResult.success();
        });
    }
}

