/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class BatonPassTests {
    @BattleTest
    public static CompletableFuture<TestResult> testSwitchesOutWithStatChanges(BattleTestHelper helper) {
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).heldItem(PixelmonItems.lagging_tail).ability(AbilityRegistry.MAGIC_GUARD).moves(AttackRegistry.BATON_PASS, AttackRegistry.SUBSTITUTE, AttackRegistry.SWORDS_DANCE, AttackRegistry.FOCUS_ENERGY).build();
        Pokemon wingull = helper.createDefaultPokemon(PixelmonSpecies.WINGULL).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant passer = helper.createParticipant(1, wynaut, wingull);
        TestParticipant pichu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PICHU).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.LEECH_SEED, AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(passer, pichu).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                passer.attackSelf(wynaut, 4);
                pichu.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                passer.attackSelf(wynaut, 3);
                pichu.attackOpponent(2);
            });
            controller.takeFullTurn(() -> {
                passer.attackSelf(wynaut, 2);
                pichu.attackOpponent(2);
            });
            controller.takeFullTurn(() -> {
                passer.attackSelf(wynaut, 1);
                passer.switchPokemon(wynaut, wingull);
                pichu.attackOpponent(2);
            });
            if (passer.asWrapper(wingull).getBattleStats().getCritStage() != 2) {
                return TestResult.failure("Baton Pass did not pass Focus Energy.");
            }
            if (!passer.asWrapper(wingull).hasStatus(StatusType.Leech)) {
                return TestResult.failure("Baton Pass did not pass Leech Seed.");
            }
            if (passer.asWrapper(wingull).getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Baton Pass did not pass stat changes.");
            }
            if (!passer.asWrapper(wingull).hasStatus(StatusType.Substitute)) {
                return TestResult.failure("Baton Pass did not pass Substitute");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testFailsWithoutSwitchSingles(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.BATON_PASS, AttackRegistry.SWORDS_DANCE).build());
        TestParticipant pichu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PICHU).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(wynaut, pichu).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                wynaut.attackSelf(2);
                pichu.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                wynaut.attackSelf(1);
                pichu.attackOpponent(1);
            });
            if (!wynaut.asWrapper().onBattlefield) {
                return TestResult.failure("Baton Pass could be used despite the user not having a teammate to switch to, and the user left the field.");
            }
            if (wynaut.asWrapper().lastAttack.moveResult.result.isSuccess()) {
                return TestResult.failure("Baton Pass could be used despite the user not having a teammate to switch to.");
            }
            if (wynaut.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Baton Pass removed stat changes despite the user not switching out.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testFailsWithoutSwitchDoubles(BattleTestHelper helper) {
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.BATON_PASS, AttackRegistry.SWORDS_DANCE).build();
        Pokemon pichu1 = helper.createDefaultPokemon(PixelmonSpecies.PICHU).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant passer = helper.createParticipant(2, wynaut, pichu1);
        Pokemon pichu2 = helper.createDefaultPokemon(PixelmonSpecies.PICHU).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon pichu3 = helper.createDefaultPokemon(PixelmonSpecies.PICHU).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant defender = helper.createParticipant(2, pichu2, pichu3);
        return helper.setupDoubleBattleBuilder(passer, defender).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                passer.attackSelf(wynaut, 2);
                passer.attackOpponent(pichu1, 1);
                defender.attackOpponent(pichu2, 1);
                defender.attackOpponent(pichu3, 1);
            });
            controller.takeFullTurn(() -> {
                passer.attackSelf(wynaut, 1);
                passer.attackOpponent(pichu1, 1);
                defender.attackOpponent(pichu2, 1);
                defender.attackOpponent(pichu3, 1);
            });
            if (!passer.asWrapper((Pokemon)wynaut).onBattlefield) {
                return TestResult.failure("Baton Pass could be used despite the user not having a teammate to switch to, and the user left the field.");
            }
            if (passer.asWrapper((Pokemon)wynaut).lastAttack.moveResult.result.isSuccess()) {
                return TestResult.failure("Baton Pass could be used despite the user not having a teammate to switch to.");
            }
            if (passer.asWrapper(wynaut).getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Baton Pass removed stat changes despite the user not switching out.");
            }
            return TestResult.success();
        });
    }
}

