/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class AuraWheelTests {
    @BattleTest
    public static CompletableFuture<TestResult> testChangesTypeWithHungerSwitch(BattleTestHelper helper) {
        TestParticipant morpeko = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MORPEKO).ability(AbilityRegistry.HUNGER_SWITCH).moves(AttackRegistry.AURA_WHEEL).build());
        TestParticipant rhyperior = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RHYPERIOR).ability(AbilityRegistry.SOLID_ROCK).moves(AttackRegistry.SLEEP_TALK).heldItem(PixelmonItems.focus_sash).build());
        return helper.setupSingleBattleBuilder(morpeko, rhyperior).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                morpeko.attackOpponent(1);
                rhyperior.attackOpponent(1);
            });
            if (morpeko.asWrapper().lastAttack.getType() != Element.ELECTRIC) {
                return TestResult.failure("Aura Wheel did not start as Electric type.");
            }
            controller.takeFullTurn(() -> {
                morpeko.attackOpponent(1);
                rhyperior.attackOpponent(1);
            });
            if (rhyperior.asWrapper().lastDirectDamage == 0) {
                return TestResult.failure("Aura Wheel did not change to Dark type.");
            }
            return TestResult.success();
        });
    }
}

