/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class AssuranceTests {
    @BattleTest
    public static CompletableFuture<TestResult> testDoublesPowerAgainstDamagedTarget(BattleTestHelper helper) {
        TestParticipant sneasel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SNEASEL).level(1).ability(AbilityRegistry.STURDY).moves(AttackRegistry.ASSURANCE).build());
        TestParticipant regieleki = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).level(100).moves(AttackRegistry.WILD_CHARGE).build());
        return helper.setupSingleBattleBuilder(sneasel, regieleki).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                regieleki.attackOpponent(1);
                sneasel.attackOpponent(1);
            });
            if (sneasel.asWrapper().lastAttack.movePower != 120) {
                return TestResult.failure("Assurance did not double Base Power on a target damaged this turn.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testPowerBasedOnTargetNotSlot(BattleTestHelper helper) {
        Pokemon alakazam = helper.createDefaultPokemon(PixelmonSpecies.ALAKAZAM).level(100).moves(AttackRegistry.PSYCHIC).build();
        Pokemon pawniard = helper.createDefaultPokemon(PixelmonSpecies.PAWNIARD).heldItem(PixelmonItems.lagging_tail).moves(AttackRegistry.ASSURANCE).build();
        TestParticipant attacker = helper.createParticipant(2, alakazam, pawniard);
        Pokemon bulbasaur = helper.createDefaultPokemon(PixelmonSpecies.BULBASAUR).level(1).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon landorus = helper.createDefaultPokemon(PixelmonSpecies.LANDORUS).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant defender = helper.createParticipant(2, bulbasaur, landorus);
        return helper.setupDoubleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(alakazam, 1, bulbasaur);
                attacker.attackTarget(pawniard, 1, bulbasaur);
                defender.attackSelf(bulbasaur, 1);
                defender.attackSelf(landorus, 1);
            });
            if (attacker.asWrapper((Pokemon)pawniard).lastAttack.movePower != 60) {
                return TestResult.failure("Power doubled against an undamaged target in the slot of Pokemon that fainted this turn.");
            }
            return TestResult.success();
        });
    }

    public static CompletableFuture<TestResult> testShouldNotDoublePowerAfterPainSplit(BattleTestHelper helper) {
        TestParticipant greedent = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GREEDENT).heldItem(PixelmonItems.lagging_tail).moves(AttackRegistry.ASSURANCE).build());
        TestParticipant wailord = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WAILORD).moves(AttackRegistry.PAIN_SPLIT).build());
        return helper.setupSingleBattleBuilder(greedent, wailord).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                wailord.attackOpponent(1);
                greedent.attackOpponent(1);
            });
            if (greedent.asWrapper().lastAttack.movePower != 60) {
                return TestResult.failure("Assurance doubled power on a target that used Pain Split this turn.");
            }
            return TestResult.success();
        });
    }
}

