/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.Burn;
import com.pixelmonmod.pixelmon.battles.status.Freeze;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.PoisonBadly;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class AromatherapyTests {
    @BattleTest
    public static CompletableFuture<TestResult> testHealsStatusOfUsersFullTeam(BattleTestHelper helper) {
        Pokemon dunsparce = helper.createDefaultPokemon(PixelmonSpecies.DUNSPARCE).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon chansey = helper.createDefaultPokemon(PixelmonSpecies.CHANSEY).moves(AttackRegistry.AROMATHERAPY).build();
        TestParticipant team = helper.createParticipant(dunsparce, chansey);
        TestParticipant nidoking = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.NIDOKING).moves(AttackRegistry.TOXIC, AttackRegistry.GLARE).build());
        return helper.setupSingleBattleBuilder(team, nidoking).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackOpponent(1);
                nidoking.attackOpponent(2);
            });
            controller.takeFullTurn(() -> {
                team.switchPokemon(dunsparce, chansey);
                nidoking.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                team.attackOpponent(1);
                nidoking.attackOpponent(2);
            });
            if (team.asWrapper(chansey).hasStatus(StatusType.PoisonBadly)) {
                return TestResult.failure("Aromatherapy should remove own poisoned status.");
            }
            if (team.asWrapper(dunsparce).hasStatus(StatusType.Paralysis)) {
                return TestResult.failure("Aromatherapy should remove reserve pokemon's paralyzed status.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotBypassAllySubstituteToHealStatus(BattleTestHelper helper) {
        Pokemon dunsparce = helper.createDefaultPokemon(PixelmonSpecies.DUNSPARCE).moves(AttackRegistry.SUBSTITUTE, AttackRegistry.SLEEP_TALK).build();
        Pokemon chansey = helper.createDefaultPokemon(PixelmonSpecies.CHANSEY).ability(AbilityRegistry.SERENE_GRACE).moves(AttackRegistry.SUBSTITUTE, AttackRegistry.AROMATHERAPY).build();
        TestParticipant team = helper.createParticipant(2, dunsparce, chansey);
        TestParticipant glimmora = helper.createParticipant(2, helper.createDefaultPokemon(PixelmonSpecies.GLIMMORA).moves(AttackRegistry.MORTAL_SPIN, AttackRegistry.SLEEP_TALK).build());
        return helper.setupDoubleBattleBuilder(team, glimmora).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackSelf(chansey, 1);
                team.attackSelf(dunsparce, 1);
                glimmora.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                team.attackSelf(chansey, 2);
                team.attackOpponent(dunsparce, 2);
                glimmora.attackOpponent(2);
            });
            if (team.asWrapper(chansey).hasStatus(StatusType.Poison)) {
                return TestResult.failure("Aromatherapy should cure own poisoned status behind Substitute.");
            }
            if (!team.asWrapper(dunsparce).hasStatus(StatusType.Poison)) {
                return TestResult.failure("Aromatherapy should not bypass Substitute to remove ally's poisoned status.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotCureOpponents(BattleTestHelper helper) {
        Pokemon dunsparce = helper.createDefaultPokemon(PixelmonSpecies.DUNSPARCE).moves(AttackRegistry.SUBSTITUTE, AttackRegistry.SLEEP_TALK).build();
        Pokemon chansey = helper.createDefaultPokemon(PixelmonSpecies.CHANSEY).ability(AbilityRegistry.SERENE_GRACE).moves(AttackRegistry.SUBSTITUTE, AttackRegistry.AROMATHERAPY).build();
        TestParticipant team = helper.createParticipant(2, dunsparce, chansey);
        TestParticipant glimmora = helper.createParticipant(2, helper.createDefaultPokemon(PixelmonSpecies.GLIMMORA).moves(AttackRegistry.MORTAL_SPIN, AttackRegistry.SLEEP_TALK).heldItem(PixelmonItems.flame_orb).build());
        return helper.setupDoubleBattleBuilder(team, glimmora).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                team.attackSelf(chansey, 1);
                team.attackSelf(dunsparce, 1);
                glimmora.attackAutoTarget(1);
            });
            controller.takeFullTurn(() -> {
                team.attackSelf(chansey, 2);
                team.attackOpponent(dunsparce, 2);
                glimmora.attackOpponent(2);
            });
            if (team.asWrapper(chansey).hasStatus(StatusType.Poison)) {
                return TestResult.failure("Aromatherapy should cure own poisoned status behind Substitute.");
            }
            if (!team.asWrapper(dunsparce).hasStatus(StatusType.Poison)) {
                return TestResult.failure("Aromatherapy should not bypass Substitute to remove ally's poisoned status.");
            }
            if (!glimmora.asWrapper().hasStatus(StatusType.Burn)) {
                return TestResult.failure("Aromatherapy should not remove opponent's status.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testHealsStatusOfAlliedFullTeams(BattleTestHelper helper) {
        Pokemon azumarill = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.HUGE_POWER).moves(AttackRegistry.SLEEP_TALK).status(new Burn()).build();
        Pokemon reserve = helper.createDefaultPokemon(PixelmonSpecies.DUDUNSPARCE).moves(AttackRegistry.SLEEP_TALK).status(new Freeze()).build();
        TestParticipant ally = helper.createParticipant(azumarill, reserve);
        Pokemon dunsparce = helper.createDefaultPokemon(PixelmonSpecies.DUNSPARCE).moves(AttackRegistry.SLEEP_TALK).status(new Paralysis()).build();
        Pokemon chansey = helper.createDefaultPokemon(PixelmonSpecies.CHANSEY).moves(AttackRegistry.AROMATHERAPY).status(new Poison()).build();
        TestParticipant team = helper.createParticipant(chansey, dunsparce);
        TestParticipant nidoking = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.NIDOKING).moves(AttackRegistry.SLEEP_TALK).status(new Burn()).build());
        TestParticipant glimmora = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GLIMMORA).moves(AttackRegistry.SLEEP_TALK).status(new PoisonBadly()).build());
        return helper.setupDoubleBattleBuilder(ally, team, nidoking, glimmora).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                glimmora.attackOpponent(1);
                nidoking.attackOpponent(1);
                ally.attackOpponent(1);
                team.attackAutoTarget(1);
            });
            if (team.asWrapper(chansey).hasNonVolatileStatus()) {
                return TestResult.failure("Aromatherapy should remove own poisoned status.");
            }
            if (team.asWrapper(dunsparce).hasNonVolatileStatus()) {
                return TestResult.failure("Aromatherapy should remove reserve pokemon's paralyzed status.");
            }
            if (ally.asWrapper(azumarill).hasNonVolatileStatus()) {
                return TestResult.failure("Aromatherapy should remove ally's burned status.");
            }
            if (ally.asWrapper(reserve).hasNonVolatileStatus()) {
                return TestResult.failure("Aromatherapy should remove ally's reserve pokemon's frozen status.");
            }
            if (!nidoking.asWrapper().hasNonVolatileStatus()) {
                return TestResult.failure("Aromatherapy should not remove opponent's burn status.");
            }
            if (!glimmora.asWrapper().hasNonVolatileStatus()) {
                return TestResult.failure("Aromatherapy should not remove opponent's badly poisoned status.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotHealActiveSapSipperAllies(BattleTestHelper helper) {
        TestParticipant azumarill = helper.createParticipant(2, helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).moves(AttackRegistry.SLEEP_TALK).build());
        Pokemon voltorb = helper.createDefaultPokemon(PixelmonSpecies.VOLTORB).ability(AbilityRegistry.SAP_SIPPER).moves(AttackRegistry.SLEEP_TALK).status(new Paralysis()).build();
        Pokemon chansey = helper.createDefaultPokemon(PixelmonSpecies.CHANSEY).ability(AbilityRegistry.SAP_SIPPER).moves(AttackRegistry.AROMATHERAPY).status(new Poison()).build();
        Pokemon reserve = helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.SAP_SIPPER).moves(AttackRegistry.SLEEP_TALK).status(new Freeze()).build();
        TestParticipant team = helper.createParticipant(2, chansey, voltorb, reserve);
        return helper.setupDoubleBattleBuilder(azumarill, team).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                azumarill.attackOpponent(1);
                team.attackOpponent(voltorb, 1);
                team.attackAutoTarget(chansey, 1);
            });
            if (team.asWrapper(chansey).hasNonVolatileStatus()) {
                return TestResult.failure("Aromatherapy should remove own poisoned status ignoring SapSipper.");
            }
            if (!team.asWrapper(voltorb).hasNonVolatileStatus() && team.asWrapper(voltorb).getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("SapSipper pokemon on the field should gain attack instead.");
            }
            if (team.asWrapper(reserve).hasNonVolatileStatus()) {
                return TestResult.failure("SapSipper pokemon not on the field should not block Aromatherapy.");
            }
            return TestResult.success();
        });
    }
}

