/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.move;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class AfterYouTests {
    @BattleTest
    public static CompletableFuture<TestResult> testCausesTargetToImmediatelyMoveNext(BattleTestHelper helper) {
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.AFTER_YOU).build();
        Pokemon magnemite = helper.createDefaultPokemon(PixelmonSpecies.MAGNEMITE).level(1).ability(AbilityRegistry.MAGNET_PULL).moves(AttackRegistry.MAGNET_RISE).build();
        TestParticipant attacker = helper.createParticipant(2, wynaut, magnemite);
        Pokemon greattusk = helper.createDefaultPokemon(PixelmonSpecies.GREATTUSK).moves(AttackRegistry.HEADLONG_RUSH).build();
        Pokemon magikarp = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant defender = helper.createParticipant(2, greattusk, magikarp);
        return helper.setupDoubleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(wynaut, 1, magnemite);
                attacker.attackSelf(magnemite, 1);
                defender.attackOpponent(greattusk, 1);
                defender.attackOpponent(magikarp, 1);
            });
            if (attacker.asWrapper(magnemite).isFainted()) {
                return TestResult.failure("After You did not cause the target to immediately move next.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotUseAsSubMove(BattleTestHelper helper) {
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.AFTER_YOU).build();
        Pokemon necrozma = helper.createDefaultPokemon(PixelmonSpecies.NECROZMA).level(50).moves(AttackRegistry.PHOTON_GEYSER).build();
        TestParticipant attacker = helper.createParticipant(2, wynaut, necrozma);
        Pokemon dugtrio = helper.createDefaultPokemon(PixelmonSpecies.DUGTRIO).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon roggenrola = helper.createDefaultPokemon(PixelmonSpecies.ROGGENROLA).level(1).moves(AttackRegistry.SLEEP_TALK).ability(AbilityRegistry.STURDY).build();
        TestParticipant defender = helper.createParticipant(2, dugtrio, roggenrola);
        return helper.setupDoubleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(wynaut, 1, necrozma);
                attacker.attackTarget(necrozma, 1, roggenrola);
                defender.attackOpponent(dugtrio, 1);
                defender.attackOpponent(roggenrola, 1);
            });
            if (!defender.asWrapper(roggenrola).isFainted()) {
                return TestResult.failure("After You caused Photon Geyser to be used as a submove.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldFailWhenUsedAfterTarget(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant tyrogue = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TYROGUE).heldItem(PixelmonItems.lagging_tail).moves(AttackRegistry.AFTER_YOU).build());
        return helper.setupSingleBattleBuilder(wynaut, tyrogue).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                wynaut.attackOpponent(1);
                tyrogue.attackOpponent(1);
            });
            if (tyrogue.asWrapper().lastAttack.moveResult.result.isSuccess()) {
                return TestResult.failure("After You did not fail when used last.");
            }
            return TestResult.success();
        });
    }
}

